/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.IPSet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IPSetMarshaller {
    private static final MarshallingInfo<String> IPSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IPSetId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> IPSETDESCRIPTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IPSetDescriptors").isBinary(false).build();
    private static final IPSetMarshaller INSTANCE = new IPSetMarshaller();

    private IPSetMarshaller() {
    }

    public static IPSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IPSet ipSet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ipSet, (String)"ipSet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ipSet.ipSetId(), IPSETID_BINDING);
            protocolMarshaller.marshall((Object)ipSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(ipSet.ipSetDescriptors(), IPSETDESCRIPTORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

