/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.GetWebACLRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetWebACLRequestModelMarshaller {
    private static final MarshallingInfo<String> WEBACLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebACLId").isBinary(false).build();
    private static final GetWebACLRequestModelMarshaller INSTANCE = new GetWebACLRequestModelMarshaller();

    private GetWebACLRequestModelMarshaller() {
    }

    public static GetWebACLRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetWebACLRequest getWebACLRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getWebACLRequest), (String)"getWebACLRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getWebACLRequest.webACLId(), WEBACLID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

