/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ByteMatchTupleMarshaller {
    private static final MarshallingInfo<StructuredPojo> FIELDTOMATCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FieldToMatch").isBinary(false).build();
    private static final MarshallingInfo<ByteBuffer> TARGETSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetString").isBinary(false).build();
    private static final MarshallingInfo<String> TEXTTRANSFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextTransformation").isBinary(false).build();
    private static final MarshallingInfo<String> POSITIONALCONSTRAINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PositionalConstraint").isBinary(false).build();
    private static final ByteMatchTupleMarshaller INSTANCE = new ByteMatchTupleMarshaller();

    private ByteMatchTupleMarshaller() {
    }

    public static ByteMatchTupleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ByteMatchTuple byteMatchTuple, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)byteMatchTuple, (String)"byteMatchTuple");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)byteMatchTuple.fieldToMatch(), FIELDTOMATCH_BINDING);
            protocolMarshaller.marshall((Object)byteMatchTuple.targetString(), TARGETSTRING_BINDING);
            protocolMarshaller.marshall((Object)byteMatchTuple.textTransformationAsString(), TEXTTRANSFORMATION_BINDING);
            protocolMarshaller.marshall((Object)byteMatchTuple.positionalConstraintAsString(), POSITIONALCONSTRAINT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

