/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.RegexMatchTuple;
import software.amazon.awssdk.services.waf.transform.RegexMatchSetUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegexMatchSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, RegexMatchSetUpdate> {
    private final String action;
    private final RegexMatchTuple regexMatchTuple;

    private RegexMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.regexMatchTuple = builder.regexMatchTuple;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public RegexMatchTuple regexMatchTuple() {
        return this.regexMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexMatchTuple());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexMatchSetUpdate)) {
            return false;
        }
        RegexMatchSetUpdate other = (RegexMatchSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.regexMatchTuple(), other.regexMatchTuple());
    }

    public String toString() {
        return ToString.builder((String)"RegexMatchSetUpdate").add("Action", (Object)this.actionAsString()).add("RegexMatchTuple", (Object)this.regexMatchTuple()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionAsString()));
            }
            case "RegexMatchTuple": {
                return Optional.of(clazz.cast(this.regexMatchTuple()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegexMatchSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private RegexMatchTuple regexMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(RegexMatchSetUpdate model) {
            this.action(model.action);
            this.regexMatchTuple(model.regexMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final RegexMatchTuple.Builder getRegexMatchTuple() {
            return this.regexMatchTuple != null ? this.regexMatchTuple.toBuilder() : null;
        }

        @Override
        public final Builder regexMatchTuple(RegexMatchTuple regexMatchTuple) {
            this.regexMatchTuple = regexMatchTuple;
            return this;
        }

        public final void setRegexMatchTuple(RegexMatchTuple.BuilderImpl regexMatchTuple) {
            this.regexMatchTuple = regexMatchTuple != null ? regexMatchTuple.build() : null;
        }

        public RegexMatchSetUpdate build() {
            return new RegexMatchSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegexMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder regexMatchTuple(RegexMatchTuple var1);

        default public Builder regexMatchTuple(Consumer<RegexMatchTuple.Builder> regexMatchTuple) {
            return this.regexMatchTuple((RegexMatchTuple)((RegexMatchTuple.Builder)RegexMatchTuple.builder().apply(regexMatchTuple)).build());
        }
    }
}

