/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.waf.model.RegexPatternSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.RegexPatternSetSummary;
import software.amazon.awssdk.services.waf.model.WAFResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRegexPatternSetsResponse
extends WAFResponse
implements ToCopyableBuilder<Builder, ListRegexPatternSetsResponse> {
    private final String nextMarker;
    private final List<RegexPatternSetSummary> regexPatternSets;

    private ListRegexPatternSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.regexPatternSets = builder.regexPatternSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<RegexPatternSetSummary> regexPatternSets() {
        return this.regexPatternSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexPatternSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegexPatternSetsResponse)) {
            return false;
        }
        ListRegexPatternSetsResponse other = (ListRegexPatternSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.regexPatternSets(), other.regexPatternSets());
    }

    public String toString() {
        return ToString.builder((String)"ListRegexPatternSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("RegexPatternSets", this.regexPatternSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "RegexPatternSets": {
                return Optional.of(clazz.cast(this.regexPatternSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<RegexPatternSetSummary> regexPatternSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegexPatternSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.regexPatternSets(model.regexPatternSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<RegexPatternSetSummary.Builder> getRegexPatternSets() {
            return this.regexPatternSets != null ? (Collection)this.regexPatternSets.stream().map(RegexPatternSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regexPatternSets(Collection<RegexPatternSetSummary> regexPatternSets) {
            this.regexPatternSets = RegexPatternSetSummariesCopier.copy(regexPatternSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexPatternSets(RegexPatternSetSummary ... regexPatternSets) {
            this.regexPatternSets(Arrays.asList(regexPatternSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexPatternSets(Consumer<RegexPatternSetSummary.Builder> ... regexPatternSets) {
            this.regexPatternSets(Stream.of(regexPatternSets).map(c -> (RegexPatternSetSummary)((RegexPatternSetSummary.Builder)RegexPatternSetSummary.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegexPatternSets(Collection<RegexPatternSetSummary.BuilderImpl> regexPatternSets) {
            this.regexPatternSets = RegexPatternSetSummariesCopier.copyFromBuilder(regexPatternSets);
        }

        @Override
        public ListRegexPatternSetsResponse build() {
            return new ListRegexPatternSetsResponse(this);
        }
    }

    public static interface Builder
    extends WAFResponse.Builder,
    CopyableBuilder<Builder, ListRegexPatternSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder regexPatternSets(Collection<RegexPatternSetSummary> var1);

        public Builder regexPatternSets(RegexPatternSetSummary ... var1);

        public Builder regexPatternSets(Consumer<RegexPatternSetSummary.Builder> ... var1);
    }
}

