/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetRateBasedRuleManagedKeysRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, GetRateBasedRuleManagedKeysRequest> {
    private final String ruleId;
    private final String nextMarker;

    private GetRateBasedRuleManagedKeysRequest(BuilderImpl builder) {
        super(builder);
        this.ruleId = builder.ruleId;
        this.nextMarker = builder.nextMarker;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRateBasedRuleManagedKeysRequest)) {
            return false;
        }
        GetRateBasedRuleManagedKeysRequest other = (GetRateBasedRuleManagedKeysRequest)((Object)obj);
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"GetRateBasedRuleManagedKeysRequest").add("RuleId", (Object)this.ruleId()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleId": {
                return Optional.of(clazz.cast(this.ruleId()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String ruleId;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRateBasedRuleManagedKeysRequest model) {
            super(model);
            this.ruleId(model.ruleId);
            this.nextMarker(model.nextMarker);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetRateBasedRuleManagedKeysRequest build() {
            return new GetRateBasedRuleManagedKeysRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, GetRateBasedRuleManagedKeysRequest> {
        public Builder ruleId(String var1);

        public Builder nextMarker(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

