/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.transform.ByteMatchSetUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ByteMatchSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ByteMatchSetUpdate> {
    private final String action;
    private final ByteMatchTuple byteMatchTuple;

    private ByteMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.byteMatchTuple = builder.byteMatchTuple;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public ByteMatchTuple byteMatchTuple() {
        return this.byteMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byteMatchTuple());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSetUpdate)) {
            return false;
        }
        ByteMatchSetUpdate other = (ByteMatchSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.byteMatchTuple(), other.byteMatchTuple());
    }

    public String toString() {
        return ToString.builder((String)"ByteMatchSetUpdate").add("Action", (Object)this.actionAsString()).add("ByteMatchTuple", (Object)this.byteMatchTuple()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionAsString()));
            }
            case "ByteMatchTuple": {
                return Optional.of(clazz.cast(this.byteMatchTuple()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ByteMatchSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ByteMatchTuple byteMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSetUpdate model) {
            this.action(model.action);
            this.byteMatchTuple(model.byteMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final ByteMatchTuple.Builder getByteMatchTuple() {
            return this.byteMatchTuple != null ? this.byteMatchTuple.toBuilder() : null;
        }

        @Override
        public final Builder byteMatchTuple(ByteMatchTuple byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple;
            return this;
        }

        public final void setByteMatchTuple(ByteMatchTuple.BuilderImpl byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple != null ? byteMatchTuple.build() : null;
        }

        public ByteMatchSetUpdate build() {
            return new ByteMatchSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ByteMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder byteMatchTuple(ByteMatchTuple var1);

        default public Builder byteMatchTuple(Consumer<ByteMatchTuple.Builder> byteMatchTuple) {
            return this.byteMatchTuple((ByteMatchTuple)((ByteMatchTuple.Builder)ByteMatchTuple.builder().apply(byteMatchTuple)).build());
        }
    }
}

