/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;
import software.amazon.awssdk.services.waf.model.ByteMatchTuplesCopier;
import software.amazon.awssdk.services.waf.transform.ByteMatchSetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ByteMatchSet
implements StructuredPojo,
ToCopyableBuilder<Builder, ByteMatchSet> {
    private final String byteMatchSetId;
    private final String name;
    private final List<ByteMatchTuple> byteMatchTuples;

    private ByteMatchSet(BuilderImpl builder) {
        this.byteMatchSetId = builder.byteMatchSetId;
        this.name = builder.name;
        this.byteMatchTuples = builder.byteMatchTuples;
    }

    public String byteMatchSetId() {
        return this.byteMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public List<ByteMatchTuple> byteMatchTuples() {
        return this.byteMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.byteMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.byteMatchTuples());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSet)) {
            return false;
        }
        ByteMatchSet other = (ByteMatchSet)obj;
        return Objects.equals(this.byteMatchSetId(), other.byteMatchSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.byteMatchTuples(), other.byteMatchTuples());
    }

    public String toString() {
        return ToString.builder((String)"ByteMatchSet").add("ByteMatchSetId", (Object)this.byteMatchSetId()).add("Name", (Object)this.name()).add("ByteMatchTuples", this.byteMatchTuples()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ByteMatchSetId": {
                return Optional.of(clazz.cast(this.byteMatchSetId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ByteMatchTuples": {
                return Optional.of(clazz.cast(this.byteMatchTuples()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ByteMatchSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String byteMatchSetId;
        private String name;
        private List<ByteMatchTuple> byteMatchTuples;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSet model) {
            this.byteMatchSetId(model.byteMatchSetId);
            this.name(model.name);
            this.byteMatchTuples(model.byteMatchTuples);
        }

        public final String getByteMatchSetId() {
            return this.byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<ByteMatchTuple.Builder> getByteMatchTuples() {
            return this.byteMatchTuples != null ? (Collection)this.byteMatchTuples.stream().map(ByteMatchTuple::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder byteMatchTuples(Collection<ByteMatchTuple> byteMatchTuples) {
            this.byteMatchTuples = ByteMatchTuplesCopier.copy(byteMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchTuples(ByteMatchTuple ... byteMatchTuples) {
            this.byteMatchTuples(Arrays.asList(byteMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchTuples(Consumer<ByteMatchTuple.Builder> ... byteMatchTuples) {
            this.byteMatchTuples(Stream.of(byteMatchTuples).map(c -> (ByteMatchTuple)((ByteMatchTuple.Builder)ByteMatchTuple.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setByteMatchTuples(Collection<ByteMatchTuple.BuilderImpl> byteMatchTuples) {
            this.byteMatchTuples = ByteMatchTuplesCopier.copyFromBuilder(byteMatchTuples);
        }

        public ByteMatchSet build() {
            return new ByteMatchSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ByteMatchSet> {
        public Builder byteMatchSetId(String var1);

        public Builder name(String var1);

        public Builder byteMatchTuples(Collection<ByteMatchTuple> var1);

        public Builder byteMatchTuples(ByteMatchTuple ... var1);

        public Builder byteMatchTuples(Consumer<ByteMatchTuple.Builder> ... var1);
    }
}

