/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.XssMatchTuple;
import software.amazon.awssdk.services.waf.model.XssMatchTuplesCopier;
import software.amazon.awssdk.services.waf.transform.XssMatchSetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class XssMatchSet
implements StructuredPojo,
ToCopyableBuilder<Builder, XssMatchSet> {
    private final String xssMatchSetId;
    private final String name;
    private final List<XssMatchTuple> xssMatchTuples;

    private XssMatchSet(BuilderImpl builder) {
        this.xssMatchSetId = builder.xssMatchSetId;
        this.name = builder.name;
        this.xssMatchTuples = builder.xssMatchTuples;
    }

    public String xssMatchSetId() {
        return this.xssMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public List<XssMatchTuple> xssMatchTuples() {
        return this.xssMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.xssMatchSetId() == null ? 0 : this.xssMatchSetId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.xssMatchTuples() == null ? 0 : this.xssMatchTuples().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchSet)) {
            return false;
        }
        XssMatchSet other = (XssMatchSet)obj;
        if (other.xssMatchSetId() == null ^ this.xssMatchSetId() == null) {
            return false;
        }
        if (other.xssMatchSetId() != null && !other.xssMatchSetId().equals(this.xssMatchSetId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.xssMatchTuples() == null ^ this.xssMatchTuples() == null) {
            return false;
        }
        return other.xssMatchTuples() == null || other.xssMatchTuples().equals(this.xssMatchTuples());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.xssMatchSetId() != null) {
            sb.append("XssMatchSetId: ").append(this.xssMatchSetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.xssMatchTuples() != null) {
            sb.append("XssMatchTuples: ").append(this.xssMatchTuples()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        XssMatchSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String xssMatchSetId;
        private String name;
        private List<XssMatchTuple> xssMatchTuples;

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchSet model) {
            this.setXssMatchSetId(model.xssMatchSetId);
            this.setName(model.name);
            this.setXssMatchTuples(model.xssMatchTuples);
        }

        public final String getXssMatchSetId() {
            return this.xssMatchSetId;
        }

        @Override
        public final Builder xssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
            return this;
        }

        public final void setXssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<XssMatchTuple> getXssMatchTuples() {
            return this.xssMatchTuples;
        }

        @Override
        public final Builder xssMatchTuples(Collection<XssMatchTuple> xssMatchTuples) {
            this.xssMatchTuples = XssMatchTuplesCopier.copy(xssMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchTuples(XssMatchTuple ... xssMatchTuples) {
            if (this.xssMatchTuples == null) {
                this.xssMatchTuples = new ArrayList<XssMatchTuple>(xssMatchTuples.length);
            }
            for (XssMatchTuple e : xssMatchTuples) {
                this.xssMatchTuples.add(e);
            }
            return this;
        }

        public final void setXssMatchTuples(Collection<XssMatchTuple> xssMatchTuples) {
            this.xssMatchTuples = XssMatchTuplesCopier.copy(xssMatchTuples);
        }

        @SafeVarargs
        public final void setXssMatchTuples(XssMatchTuple ... xssMatchTuples) {
            if (this.xssMatchTuples == null) {
                this.xssMatchTuples = new ArrayList<XssMatchTuple>(xssMatchTuples.length);
            }
            for (XssMatchTuple e : xssMatchTuples) {
                this.xssMatchTuples.add(e);
            }
        }

        public XssMatchSet build() {
            return new XssMatchSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, XssMatchSet> {
        public Builder xssMatchSetId(String var1);

        public Builder name(String var1);

        public Builder xssMatchTuples(Collection<XssMatchTuple> var1);

        public Builder xssMatchTuples(XssMatchTuple ... var1);
    }
}

