/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ActivatedRule;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.transform.WebACLUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WebACLUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, WebACLUpdate> {
    private final String action;
    private final ActivatedRule activatedRule;

    private WebACLUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.activatedRule = builder.activatedRule;
    }

    public String action() {
        return this.action;
    }

    public ActivatedRule activatedRule() {
        return this.activatedRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.activatedRule() == null ? 0 : this.activatedRule().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLUpdate)) {
            return false;
        }
        WebACLUpdate other = (WebACLUpdate)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.activatedRule() == null ^ this.activatedRule() == null) {
            return false;
        }
        return other.activatedRule() == null || other.activatedRule().equals(this.activatedRule());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.activatedRule() != null) {
            sb.append("ActivatedRule: ").append(this.activatedRule()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebACLUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private ActivatedRule activatedRule;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLUpdate model) {
            this.setAction(model.action);
            this.setActivatedRule(model.activatedRule);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(ChangeAction action) {
            this.action(action.toString());
        }

        public final ActivatedRule getActivatedRule() {
            return this.activatedRule;
        }

        @Override
        public final Builder activatedRule(ActivatedRule activatedRule) {
            this.activatedRule = activatedRule;
            return this;
        }

        public final void setActivatedRule(ActivatedRule activatedRule) {
            this.activatedRule = activatedRule;
        }

        public WebACLUpdate build() {
            return new WebACLUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebACLUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder activatedRule(ActivatedRule var1);
    }
}

