/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.SizeConstraint;
import software.amazon.awssdk.services.waf.model.SizeConstraintsCopier;
import software.amazon.awssdk.services.waf.transform.SizeConstraintSetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SizeConstraintSet
implements StructuredPojo,
ToCopyableBuilder<Builder, SizeConstraintSet> {
    private final String sizeConstraintSetId;
    private final String name;
    private final List<SizeConstraint> sizeConstraints;

    private SizeConstraintSet(BuilderImpl builder) {
        this.sizeConstraintSetId = builder.sizeConstraintSetId;
        this.name = builder.name;
        this.sizeConstraints = builder.sizeConstraints;
    }

    public String sizeConstraintSetId() {
        return this.sizeConstraintSetId;
    }

    public String name() {
        return this.name;
    }

    public List<SizeConstraint> sizeConstraints() {
        return this.sizeConstraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sizeConstraintSetId() == null ? 0 : this.sizeConstraintSetId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.sizeConstraints() == null ? 0 : this.sizeConstraints().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SizeConstraintSet)) {
            return false;
        }
        SizeConstraintSet other = (SizeConstraintSet)obj;
        if (other.sizeConstraintSetId() == null ^ this.sizeConstraintSetId() == null) {
            return false;
        }
        if (other.sizeConstraintSetId() != null && !other.sizeConstraintSetId().equals(this.sizeConstraintSetId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.sizeConstraints() == null ^ this.sizeConstraints() == null) {
            return false;
        }
        return other.sizeConstraints() == null || other.sizeConstraints().equals(this.sizeConstraints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sizeConstraintSetId() != null) {
            sb.append("SizeConstraintSetId: ").append(this.sizeConstraintSetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.sizeConstraints() != null) {
            sb.append("SizeConstraints: ").append(this.sizeConstraints()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SizeConstraintSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String sizeConstraintSetId;
        private String name;
        private List<SizeConstraint> sizeConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(SizeConstraintSet model) {
            this.setSizeConstraintSetId(model.sizeConstraintSetId);
            this.setName(model.name);
            this.setSizeConstraints(model.sizeConstraints);
        }

        public final String getSizeConstraintSetId() {
            return this.sizeConstraintSetId;
        }

        @Override
        public final Builder sizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
            return this;
        }

        public final void setSizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SizeConstraint> getSizeConstraints() {
            return this.sizeConstraints;
        }

        @Override
        public final Builder sizeConstraints(Collection<SizeConstraint> sizeConstraints) {
            this.sizeConstraints = SizeConstraintsCopier.copy(sizeConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeConstraints(SizeConstraint ... sizeConstraints) {
            if (this.sizeConstraints == null) {
                this.sizeConstraints = new ArrayList<SizeConstraint>(sizeConstraints.length);
            }
            for (SizeConstraint e : sizeConstraints) {
                this.sizeConstraints.add(e);
            }
            return this;
        }

        public final void setSizeConstraints(Collection<SizeConstraint> sizeConstraints) {
            this.sizeConstraints = SizeConstraintsCopier.copy(sizeConstraints);
        }

        @SafeVarargs
        public final void setSizeConstraints(SizeConstraint ... sizeConstraints) {
            if (this.sizeConstraints == null) {
                this.sizeConstraints = new ArrayList<SizeConstraint>(sizeConstraints.length);
            }
            for (SizeConstraint e : sizeConstraints) {
                this.sizeConstraints.add(e);
            }
        }

        public SizeConstraintSet build() {
            return new SizeConstraintSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SizeConstraintSet> {
        public Builder sizeConstraintSetId(String var1);

        public Builder name(String var1);

        public Builder sizeConstraints(Collection<SizeConstraint> var1);

        public Builder sizeConstraints(SizeConstraint ... var1);
    }
}

