/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.WebACLSummariesCopier;
import software.amazon.awssdk.services.waf.model.WebACLSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListWebACLsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListWebACLsResponse> {
    private final String nextMarker;
    private final List<WebACLSummary> webACLs;

    private ListWebACLsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.webACLs = builder.webACLs;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<WebACLSummary> webACLs() {
        return this.webACLs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.webACLs() == null ? 0 : this.webACLs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebACLsResponse)) {
            return false;
        }
        ListWebACLsResponse other = (ListWebACLsResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.webACLs() == null ^ this.webACLs() == null) {
            return false;
        }
        return other.webACLs() == null || other.webACLs().equals(this.webACLs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.webACLs() != null) {
            sb.append("WebACLs: ").append(this.webACLs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<WebACLSummary> webACLs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebACLsResponse model) {
            this.setNextMarker(model.nextMarker);
            this.setWebACLs(model.webACLs);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<WebACLSummary> getWebACLs() {
            return this.webACLs;
        }

        @Override
        public final Builder webACLs(Collection<WebACLSummary> webACLs) {
            this.webACLs = WebACLSummariesCopier.copy(webACLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webACLs(WebACLSummary ... webACLs) {
            if (this.webACLs == null) {
                this.webACLs = new ArrayList<WebACLSummary>(webACLs.length);
            }
            for (WebACLSummary e : webACLs) {
                this.webACLs.add(e);
            }
            return this;
        }

        public final void setWebACLs(Collection<WebACLSummary> webACLs) {
            this.webACLs = WebACLSummariesCopier.copy(webACLs);
        }

        @SafeVarargs
        public final void setWebACLs(WebACLSummary ... webACLs) {
            if (this.webACLs == null) {
                this.webACLs = new ArrayList<WebACLSummary>(webACLs.length);
            }
            for (WebACLSummary e : webACLs) {
                this.webACLs.add(e);
            }
        }

        public ListWebACLsResponse build() {
            return new ListWebACLsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListWebACLsResponse> {
        public Builder nextMarker(String var1);

        public Builder webACLs(Collection<WebACLSummary> var1);

        public Builder webACLs(WebACLSummary ... var1);
    }
}

