/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.HTTPHeader;
import software.amazon.awssdk.services.waf.model.HTTPHeadersCopier;
import software.amazon.awssdk.services.waf.transform.HTTPRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HTTPRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, HTTPRequest> {
    private final String clientIP;
    private final String country;
    private final String uri;
    private final String method;
    private final String httpVersion;
    private final List<HTTPHeader> headers;

    private HTTPRequest(BuilderImpl builder) {
        this.clientIP = builder.clientIP;
        this.country = builder.country;
        this.uri = builder.uri;
        this.method = builder.method;
        this.httpVersion = builder.httpVersion;
        this.headers = builder.headers;
    }

    public String clientIP() {
        return this.clientIP;
    }

    public String country() {
        return this.country;
    }

    public String uri() {
        return this.uri;
    }

    public String method() {
        return this.method;
    }

    public String httpVersion() {
        return this.httpVersion;
    }

    public List<HTTPHeader> headers() {
        return this.headers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientIP() == null ? 0 : this.clientIP().hashCode());
        hashCode = 31 * hashCode + (this.country() == null ? 0 : this.country().hashCode());
        hashCode = 31 * hashCode + (this.uri() == null ? 0 : this.uri().hashCode());
        hashCode = 31 * hashCode + (this.method() == null ? 0 : this.method().hashCode());
        hashCode = 31 * hashCode + (this.httpVersion() == null ? 0 : this.httpVersion().hashCode());
        hashCode = 31 * hashCode + (this.headers() == null ? 0 : this.headers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HTTPRequest)) {
            return false;
        }
        HTTPRequest other = (HTTPRequest)obj;
        if (other.clientIP() == null ^ this.clientIP() == null) {
            return false;
        }
        if (other.clientIP() != null && !other.clientIP().equals(this.clientIP())) {
            return false;
        }
        if (other.country() == null ^ this.country() == null) {
            return false;
        }
        if (other.country() != null && !other.country().equals(this.country())) {
            return false;
        }
        if (other.uri() == null ^ this.uri() == null) {
            return false;
        }
        if (other.uri() != null && !other.uri().equals(this.uri())) {
            return false;
        }
        if (other.method() == null ^ this.method() == null) {
            return false;
        }
        if (other.method() != null && !other.method().equals(this.method())) {
            return false;
        }
        if (other.httpVersion() == null ^ this.httpVersion() == null) {
            return false;
        }
        if (other.httpVersion() != null && !other.httpVersion().equals(this.httpVersion())) {
            return false;
        }
        if (other.headers() == null ^ this.headers() == null) {
            return false;
        }
        return other.headers() == null || other.headers().equals(this.headers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientIP() != null) {
            sb.append("ClientIP: ").append(this.clientIP()).append(",");
        }
        if (this.country() != null) {
            sb.append("Country: ").append(this.country()).append(",");
        }
        if (this.uri() != null) {
            sb.append("URI: ").append(this.uri()).append(",");
        }
        if (this.method() != null) {
            sb.append("Method: ").append(this.method()).append(",");
        }
        if (this.httpVersion() != null) {
            sb.append("HTTPVersion: ").append(this.httpVersion()).append(",");
        }
        if (this.headers() != null) {
            sb.append("Headers: ").append(this.headers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HTTPRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientIP;
        private String country;
        private String uri;
        private String method;
        private String httpVersion;
        private List<HTTPHeader> headers;

        private BuilderImpl() {
        }

        private BuilderImpl(HTTPRequest model) {
            this.setClientIP(model.clientIP);
            this.setCountry(model.country);
            this.setURI(model.uri);
            this.setMethod(model.method);
            this.setHTTPVersion(model.httpVersion);
            this.setHeaders(model.headers);
        }

        public final String getClientIP() {
            return this.clientIP;
        }

        @Override
        public final Builder clientIP(String clientIP) {
            this.clientIP = clientIP;
            return this;
        }

        public final void setClientIP(String clientIP) {
            this.clientIP = clientIP;
        }

        public final String getCountry() {
            return this.country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final String getURI() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setURI(String uri) {
            this.uri = uri;
        }

        public final String getMethod() {
            return this.method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getHTTPVersion() {
            return this.httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public final void setHTTPVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        public final Collection<HTTPHeader> getHeaders() {
            return this.headers;
        }

        @Override
        public final Builder headers(Collection<HTTPHeader> headers) {
            this.headers = HTTPHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(HTTPHeader ... headers) {
            if (this.headers == null) {
                this.headers = new ArrayList<HTTPHeader>(headers.length);
            }
            for (HTTPHeader e : headers) {
                this.headers.add(e);
            }
            return this;
        }

        public final void setHeaders(Collection<HTTPHeader> headers) {
            this.headers = HTTPHeadersCopier.copy(headers);
        }

        @SafeVarargs
        public final void setHeaders(HTTPHeader ... headers) {
            if (this.headers == null) {
                this.headers = new ArrayList<HTTPHeader>(headers.length);
            }
            for (HTTPHeader e : headers) {
                this.headers.add(e);
            }
        }

        public HTTPRequest build() {
            return new HTTPRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HTTPRequest> {
        public Builder clientIP(String var1);

        public Builder country(String var1);

        public Builder uri(String var1);

        public Builder method(String var1);

        public Builder httpVersion(String var1);

        public Builder headers(Collection<HTTPHeader> var1);

        public Builder headers(HTTPHeader ... var1);
    }
}

