/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the health check configuration of a target group. Health check configurations aren't used for target groups
 * of type <code>LAMBDA</code> or <code>ALB</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HealthCheckConfig.Builder, HealthCheckConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(HealthCheckConfig::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(HealthCheckConfig::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> PROTOCOL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocolVersion").getter(getter(HealthCheckConfig::protocolVersionAsString))
            .setter(setter(Builder::protocolVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolVersion").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(HealthCheckConfig::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(HealthCheckConfig::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthCheckIntervalSeconds")
            .getter(getter(HealthCheckConfig::healthCheckIntervalSeconds))
            .setter(setter(Builder::healthCheckIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckIntervalSeconds").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_TIMEOUT_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("healthCheckTimeoutSeconds")
            .getter(getter(HealthCheckConfig::healthCheckTimeoutSeconds)).setter(setter(Builder::healthCheckTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckTimeoutSeconds").build())
            .build();

    private static final SdkField<Integer> HEALTHY_THRESHOLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthyThresholdCount").getter(getter(HealthCheckConfig::healthyThresholdCount))
            .setter(setter(Builder::healthyThresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyThresholdCount").build())
            .build();

    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unhealthyThresholdCount").getter(getter(HealthCheckConfig::unhealthyThresholdCount))
            .setter(setter(Builder::unhealthyThresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyThresholdCount").build())
            .build();

    private static final SdkField<Matcher> MATCHER_FIELD = SdkField.<Matcher> builder(MarshallingType.SDK_POJO)
            .memberName("matcher").getter(getter(HealthCheckConfig::matcher)).setter(setter(Builder::matcher))
            .constructor(Matcher::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matcher").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, PROTOCOL_FIELD,
            PROTOCOL_VERSION_FIELD, PORT_FIELD, PATH_FIELD, HEALTH_CHECK_INTERVAL_SECONDS_FIELD,
            HEALTH_CHECK_TIMEOUT_SECONDS_FIELD, HEALTHY_THRESHOLD_COUNT_FIELD, UNHEALTHY_THRESHOLD_COUNT_FIELD, MATCHER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String protocol;

    private final String protocolVersion;

    private final Integer port;

    private final String path;

    private final Integer healthCheckIntervalSeconds;

    private final Integer healthCheckTimeoutSeconds;

    private final Integer healthyThresholdCount;

    private final Integer unhealthyThresholdCount;

    private final Matcher matcher;

    private HealthCheckConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.protocol = builder.protocol;
        this.protocolVersion = builder.protocolVersion;
        this.port = builder.port;
        this.path = builder.path;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.matcher = builder.matcher;
    }

    /**
     * <p>
     * Indicates whether health checking is enabled.
     * </p>
     * 
     * @return Indicates whether health checking is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The protocol used when performing health checks on targets. The possible protocols are <code>HTTP</code> and
     * <code>HTTPS</code>. The default is <code>HTTP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link TargetGroupProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol used when performing health checks on targets. The possible protocols are <code>HTTP</code>
     *         and <code>HTTPS</code>. The default is <code>HTTP</code>.
     * @see TargetGroupProtocol
     */
    public final TargetGroupProtocol protocol() {
        return TargetGroupProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol used when performing health checks on targets. The possible protocols are <code>HTTP</code> and
     * <code>HTTPS</code>. The default is <code>HTTP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link TargetGroupProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol used when performing health checks on targets. The possible protocols are <code>HTTP</code>
     *         and <code>HTTPS</code>. The default is <code>HTTP</code>.
     * @see TargetGroupProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The protocol version used when performing health checks on targets. The possible protocol versions are
     * <code>HTTP1</code> and <code>HTTP2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolVersion}
     * will return {@link HealthCheckProtocolVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolVersionAsString}.
     * </p>
     * 
     * @return The protocol version used when performing health checks on targets. The possible protocol versions are
     *         <code>HTTP1</code> and <code>HTTP2</code>.
     * @see HealthCheckProtocolVersion
     */
    public final HealthCheckProtocolVersion protocolVersion() {
        return HealthCheckProtocolVersion.fromValue(protocolVersion);
    }

    /**
     * <p>
     * The protocol version used when performing health checks on targets. The possible protocol versions are
     * <code>HTTP1</code> and <code>HTTP2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolVersion}
     * will return {@link HealthCheckProtocolVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolVersionAsString}.
     * </p>
     * 
     * @return The protocol version used when performing health checks on targets. The possible protocol versions are
     *         <code>HTTP1</code> and <code>HTTP2</code>.
     * @see HealthCheckProtocolVersion
     */
    public final String protocolVersionAsString() {
        return protocolVersion;
    }

    /**
     * <p>
     * The port used when performing health checks on targets. The default setting is the port that a target receives
     * traffic on.
     * </p>
     * 
     * @return The port used when performing health checks on targets. The default setting is the port that a target
     *         receives traffic on.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The destination for health checks on the targets. If the protocol version is <code>HTTP/1.1</code> or
     * <code>HTTP/2</code>, specify a valid URI (for example, <code>/path?query</code>). The default path is
     * <code>/</code>. Health checks are not supported if the protocol version is <code>gRPC</code>, however, you can
     * choose <code>HTTP/1.1</code> or <code>HTTP/2</code> and specify a valid URI.
     * </p>
     * 
     * @return The destination for health checks on the targets. If the protocol version is <code>HTTP/1.1</code> or
     *         <code>HTTP/2</code>, specify a valid URI (for example, <code>/path?query</code>). The default path is
     *         <code>/</code>. Health checks are not supported if the protocol version is <code>gRPC</code>, however,
     *         you can choose <code>HTTP/1.1</code> or <code>HTTP/2</code> and specify a valid URI.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300
     * seconds. The default is 30 seconds.
     * </p>
     * 
     * @return The approximate amount of time, in seconds, between health checks of an individual target. The range is
     *         5–300 seconds. The default is 30 seconds.
     */
    public final Integer healthCheckIntervalSeconds() {
        return healthCheckIntervalSeconds;
    }

    /**
     * <p>
     * The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The
     * default is 5 seconds.
     * </p>
     * 
     * @return The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120
     *         seconds. The default is 5 seconds.
     */
    public final Integer healthCheckTimeoutSeconds() {
        return healthCheckTimeoutSeconds;
    }

    /**
     * <p>
     * The number of consecutive successful health checks required before considering an unhealthy target healthy. The
     * range is 2–10. The default is 5.
     * </p>
     * 
     * @return The number of consecutive successful health checks required before considering an unhealthy target
     *         healthy. The range is 2–10. The default is 5.
     */
    public final Integer healthyThresholdCount() {
        return healthyThresholdCount;
    }

    /**
     * <p>
     * The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10.
     * The default is 2.
     * </p>
     * 
     * @return The number of consecutive failed health checks required before considering a target unhealthy. The range
     *         is 2–10. The default is 2.
     */
    public final Integer unhealthyThresholdCount() {
        return unhealthyThresholdCount;
    }

    /**
     * <p>
     * The codes to use when checking for a successful response from a target.
     * </p>
     * 
     * @return The codes to use when checking for a successful response from a target.
     */
    public final Matcher matcher() {
        return matcher;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocolVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(matcher());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(protocolVersionAsString(), other.protocolVersionAsString())
                && Objects.equals(port(), other.port()) && Objects.equals(path(), other.path())
                && Objects.equals(healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds())
                && Objects.equals(healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds())
                && Objects.equals(healthyThresholdCount(), other.healthyThresholdCount())
                && Objects.equals(unhealthyThresholdCount(), other.unhealthyThresholdCount())
                && Objects.equals(matcher(), other.matcher());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HealthCheckConfig").add("Enabled", enabled()).add("Protocol", protocolAsString())
                .add("ProtocolVersion", protocolVersionAsString()).add("Port", port()).add("Path", path())
                .add("HealthCheckIntervalSeconds", healthCheckIntervalSeconds())
                .add("HealthCheckTimeoutSeconds", healthCheckTimeoutSeconds())
                .add("HealthyThresholdCount", healthyThresholdCount()).add("UnhealthyThresholdCount", unhealthyThresholdCount())
                .add("Matcher", matcher()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "protocolVersion":
            return Optional.ofNullable(clazz.cast(protocolVersionAsString()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "healthCheckIntervalSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckIntervalSeconds()));
        case "healthCheckTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckTimeoutSeconds()));
        case "healthyThresholdCount":
            return Optional.ofNullable(clazz.cast(healthyThresholdCount()));
        case "unhealthyThresholdCount":
            return Optional.ofNullable(clazz.cast(unhealthyThresholdCount()));
        case "matcher":
            return Optional.ofNullable(clazz.cast(matcher()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("protocolVersion", PROTOCOL_VERSION_FIELD);
        map.put("port", PORT_FIELD);
        map.put("path", PATH_FIELD);
        map.put("healthCheckIntervalSeconds", HEALTH_CHECK_INTERVAL_SECONDS_FIELD);
        map.put("healthCheckTimeoutSeconds", HEALTH_CHECK_TIMEOUT_SECONDS_FIELD);
        map.put("healthyThresholdCount", HEALTHY_THRESHOLD_COUNT_FIELD);
        map.put("unhealthyThresholdCount", UNHEALTHY_THRESHOLD_COUNT_FIELD);
        map.put("matcher", MATCHER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckConfig, T> g) {
        return obj -> g.apply((HealthCheckConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheckConfig> {
        /**
         * <p>
         * Indicates whether health checking is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether health checking is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The protocol used when performing health checks on targets. The possible protocols are <code>HTTP</code> and
         * <code>HTTPS</code>. The default is <code>HTTP</code>.
         * </p>
         * 
         * @param protocol
         *        The protocol used when performing health checks on targets. The possible protocols are
         *        <code>HTTP</code> and <code>HTTPS</code>. The default is <code>HTTP</code>.
         * @see TargetGroupProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol used when performing health checks on targets. The possible protocols are <code>HTTP</code> and
         * <code>HTTPS</code>. The default is <code>HTTP</code>.
         * </p>
         * 
         * @param protocol
         *        The protocol used when performing health checks on targets. The possible protocols are
         *        <code>HTTP</code> and <code>HTTPS</code>. The default is <code>HTTP</code>.
         * @see TargetGroupProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupProtocol
         */
        Builder protocol(TargetGroupProtocol protocol);

        /**
         * <p>
         * The protocol version used when performing health checks on targets. The possible protocol versions are
         * <code>HTTP1</code> and <code>HTTP2</code>.
         * </p>
         * 
         * @param protocolVersion
         *        The protocol version used when performing health checks on targets. The possible protocol versions are
         *        <code>HTTP1</code> and <code>HTTP2</code>.
         * @see HealthCheckProtocolVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckProtocolVersion
         */
        Builder protocolVersion(String protocolVersion);

        /**
         * <p>
         * The protocol version used when performing health checks on targets. The possible protocol versions are
         * <code>HTTP1</code> and <code>HTTP2</code>.
         * </p>
         * 
         * @param protocolVersion
         *        The protocol version used when performing health checks on targets. The possible protocol versions are
         *        <code>HTTP1</code> and <code>HTTP2</code>.
         * @see HealthCheckProtocolVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckProtocolVersion
         */
        Builder protocolVersion(HealthCheckProtocolVersion protocolVersion);

        /**
         * <p>
         * The port used when performing health checks on targets. The default setting is the port that a target
         * receives traffic on.
         * </p>
         * 
         * @param port
         *        The port used when performing health checks on targets. The default setting is the port that a target
         *        receives traffic on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The destination for health checks on the targets. If the protocol version is <code>HTTP/1.1</code> or
         * <code>HTTP/2</code>, specify a valid URI (for example, <code>/path?query</code>). The default path is
         * <code>/</code>. Health checks are not supported if the protocol version is <code>gRPC</code>, however, you
         * can choose <code>HTTP/1.1</code> or <code>HTTP/2</code> and specify a valid URI.
         * </p>
         * 
         * @param path
         *        The destination for health checks on the targets. If the protocol version is <code>HTTP/1.1</code> or
         *        <code>HTTP/2</code>, specify a valid URI (for example, <code>/path?query</code>). The default path is
         *        <code>/</code>. Health checks are not supported if the protocol version is <code>gRPC</code>, however,
         *        you can choose <code>HTTP/1.1</code> or <code>HTTP/2</code> and specify a valid URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300
         * seconds. The default is 30 seconds.
         * </p>
         * 
         * @param healthCheckIntervalSeconds
         *        The approximate amount of time, in seconds, between health checks of an individual target. The range
         *        is 5–300 seconds. The default is 30 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds);

        /**
         * <p>
         * The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds.
         * The default is 5 seconds.
         * </p>
         * 
         * @param healthCheckTimeoutSeconds
         *        The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120
         *        seconds. The default is 5 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds);

        /**
         * <p>
         * The number of consecutive successful health checks required before considering an unhealthy target healthy.
         * The range is 2–10. The default is 5.
         * </p>
         * 
         * @param healthyThresholdCount
         *        The number of consecutive successful health checks required before considering an unhealthy target
         *        healthy. The range is 2–10. The default is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyThresholdCount(Integer healthyThresholdCount);

        /**
         * <p>
         * The number of consecutive failed health checks required before considering a target unhealthy. The range is
         * 2–10. The default is 2.
         * </p>
         * 
         * @param unhealthyThresholdCount
         *        The number of consecutive failed health checks required before considering a target unhealthy. The
         *        range is 2–10. The default is 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyThresholdCount(Integer unhealthyThresholdCount);

        /**
         * <p>
         * The codes to use when checking for a successful response from a target.
         * </p>
         * 
         * @param matcher
         *        The codes to use when checking for a successful response from a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matcher(Matcher matcher);

        /**
         * <p>
         * The codes to use when checking for a successful response from a target.
         * </p>
         * This is a convenience method that creates an instance of the {@link Matcher.Builder} avoiding the need to
         * create one manually via {@link Matcher#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Matcher.Builder#build()} is called immediately and its result is
         * passed to {@link #matcher(Matcher)}.
         * 
         * @param matcher
         *        a consumer that will call methods on {@link Matcher.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matcher(Matcher)
         */
        default Builder matcher(Consumer<Matcher.Builder> matcher) {
            return matcher(Matcher.builder().applyMutation(matcher).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String protocol;

        private String protocolVersion;

        private Integer port;

        private String path;

        private Integer healthCheckIntervalSeconds;

        private Integer healthCheckTimeoutSeconds;

        private Integer healthyThresholdCount;

        private Integer unhealthyThresholdCount;

        private Matcher matcher;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfig model) {
            enabled(model.enabled);
            protocol(model.protocol);
            protocolVersion(model.protocolVersion);
            port(model.port);
            path(model.path);
            healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            healthyThresholdCount(model.healthyThresholdCount);
            unhealthyThresholdCount(model.unhealthyThresholdCount);
            matcher(model.matcher);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TargetGroupProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getProtocolVersion() {
            return protocolVersion;
        }

        public final void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @Override
        public final Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        @Override
        public final Builder protocolVersion(HealthCheckProtocolVersion protocolVersion) {
            this.protocolVersion(protocolVersion == null ? null : protocolVersion.toString());
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return healthCheckIntervalSeconds;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return healthCheckTimeoutSeconds;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final Integer getHealthyThresholdCount() {
            return healthyThresholdCount;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final Integer getUnhealthyThresholdCount() {
            return unhealthyThresholdCount;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final Matcher.Builder getMatcher() {
            return matcher != null ? matcher.toBuilder() : null;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        @Override
        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
