/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceConfigurationResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<GetResourceConfigurationResponse.Builder, GetResourceConfigurationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetResourceConfigurationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetResourceConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetResourceConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> RESOURCE_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGatewayId").getter(getter(GetResourceConfigurationResponse::resourceGatewayId))
            .setter(setter(Builder::resourceGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayId").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationGroupId")
            .getter(getter(GetResourceConfigurationResponse::resourceConfigurationGroupId))
            .setter(setter(Builder::resourceConfigurationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationGroupId")
                    .build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetResourceConfigurationResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Boolean> ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowAssociationToShareableServiceNetwork")
            .getter(getter(GetResourceConfigurationResponse::allowAssociationToShareableServiceNetwork))
            .setter(setter(Builder::allowAssociationToShareableServiceNetwork))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("allowAssociationToShareableServiceNetwork").build()).build();

    private static final SdkField<List<String>> PORT_RANGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("portRanges")
            .getter(getter(GetResourceConfigurationResponse::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(GetResourceConfigurationResponse::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(GetResourceConfigurationResponse::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetResourceConfigurationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ResourceConfigurationDefinition> RESOURCE_CONFIGURATION_DEFINITION_FIELD = SdkField
            .<ResourceConfigurationDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("resourceConfigurationDefinition")
            .getter(getter(GetResourceConfigurationResponse::resourceConfigurationDefinition))
            .setter(setter(Builder::resourceConfigurationDefinition))
            .constructor(ResourceConfigurationDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationDefinition")
                    .build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetResourceConfigurationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> AMAZON_MANAGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("amazonManaged").getter(getter(GetResourceConfigurationResponse::amazonManaged))
            .setter(setter(Builder::amazonManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonManaged").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(GetResourceConfigurationResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetResourceConfigurationResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DOMAIN_VERIFICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainVerificationId").getter(getter(GetResourceConfigurationResponse::domainVerificationId))
            .setter(setter(Builder::domainVerificationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVerificationId").build())
            .build();

    private static final SdkField<String> DOMAIN_VERIFICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainVerificationArn").getter(getter(GetResourceConfigurationResponse::domainVerificationArn))
            .setter(setter(Builder::domainVerificationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVerificationArn").build())
            .build();

    private static final SdkField<String> DOMAIN_VERIFICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainVerificationStatus")
            .getter(getter(GetResourceConfigurationResponse::domainVerificationStatusAsString))
            .setter(setter(Builder::domainVerificationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVerificationStatus").build())
            .build();

    private static final SdkField<String> GROUP_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupDomain").getter(getter(GetResourceConfigurationResponse::groupDomain))
            .setter(setter(Builder::groupDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, RESOURCE_GATEWAY_ID_FIELD, RESOURCE_CONFIGURATION_GROUP_ID_FIELD, TYPE_FIELD,
            ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD, PORT_RANGES_FIELD, PROTOCOL_FIELD, CUSTOM_DOMAIN_NAME_FIELD,
            STATUS_FIELD, RESOURCE_CONFIGURATION_DEFINITION_FIELD, CREATED_AT_FIELD, AMAZON_MANAGED_FIELD, FAILURE_REASON_FIELD,
            LAST_UPDATED_AT_FIELD, DOMAIN_VERIFICATION_ID_FIELD, DOMAIN_VERIFICATION_ARN_FIELD, DOMAIN_VERIFICATION_STATUS_FIELD,
            GROUP_DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String arn;

    private final String resourceGatewayId;

    private final String resourceConfigurationGroupId;

    private final String type;

    private final Boolean allowAssociationToShareableServiceNetwork;

    private final List<String> portRanges;

    private final String protocol;

    private final String customDomainName;

    private final String status;

    private final ResourceConfigurationDefinition resourceConfigurationDefinition;

    private final Instant createdAt;

    private final Boolean amazonManaged;

    private final String failureReason;

    private final Instant lastUpdatedAt;

    private final String domainVerificationId;

    private final String domainVerificationArn;

    private final String domainVerificationStatus;

    private final String groupDomain;

    private GetResourceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.resourceGatewayId = builder.resourceGatewayId;
        this.resourceConfigurationGroupId = builder.resourceConfigurationGroupId;
        this.type = builder.type;
        this.allowAssociationToShareableServiceNetwork = builder.allowAssociationToShareableServiceNetwork;
        this.portRanges = builder.portRanges;
        this.protocol = builder.protocol;
        this.customDomainName = builder.customDomainName;
        this.status = builder.status;
        this.resourceConfigurationDefinition = builder.resourceConfigurationDefinition;
        this.createdAt = builder.createdAt;
        this.amazonManaged = builder.amazonManaged;
        this.failureReason = builder.failureReason;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.domainVerificationId = builder.domainVerificationId;
        this.domainVerificationArn = builder.domainVerificationArn;
        this.domainVerificationStatus = builder.domainVerificationStatus;
        this.groupDomain = builder.groupDomain;
    }

    /**
     * <p>
     * The ID of the resource configuration.
     * </p>
     * 
     * @return The ID of the resource configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the resource configuration.
     * </p>
     * 
     * @return The name of the resource configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the resource gateway used to connect to the resource configuration in a given VPC. You can specify the
     * resource gateway identifier only for resource configurations with type SINGLE, GROUP, or ARN.
     * </p>
     * 
     * @return The ID of the resource gateway used to connect to the resource configuration in a given VPC. You can
     *         specify the resource gateway identifier only for resource configurations with type SINGLE, GROUP, or ARN.
     */
    public final String resourceGatewayId() {
        return resourceGatewayId;
    }

    /**
     * <p>
     * The ID of the group resource configuration.
     * </p>
     * 
     * @return The ID of the group resource configuration.
     */
    public final String resourceConfigurationGroupId() {
        return resourceConfigurationGroupId;
    }

    /**
     * <p>
     * The type of resource configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUP</code> - A group of resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARN</code> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUP</code> - A group of resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARN</code> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final ResourceConfigurationType type() {
        return ResourceConfigurationType.fromValue(type);
    }

    /**
     * <p>
     * The type of resource configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUP</code> - A group of resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARN</code> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUP</code> - A group of resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARN</code> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies whether the resource configuration is associated with a sharable service network.
     * </p>
     * 
     * @return Specifies whether the resource configuration is associated with a sharable service network.
     */
    public final Boolean allowAssociationToShareableServiceNetwork() {
        return allowAssociationToShareableServiceNetwork;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The TCP port ranges that a consumer can use to access a resource configuration. You can separate port ranges with
     * a comma. Example: 1-65535 or 1,2,22-30
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortRanges} method.
     * </p>
     * 
     * @return The TCP port ranges that a consumer can use to access a resource configuration. You can separate port
     *         ranges with a comma. Example: 1-65535 or 1,2,22-30
     */
    public final List<String> portRanges() {
        return portRanges;
    }

    /**
     * <p>
     * The TCP protocol accepted by the specified resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The TCP protocol accepted by the specified resource configuration.
     * @see ProtocolType
     */
    public final ProtocolType protocol() {
        return ProtocolType.fromValue(protocol);
    }

    /**
     * <p>
     * The TCP protocol accepted by the specified resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The TCP protocol accepted by the specified resource configuration.
     * @see ProtocolType
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The custom domain name of the resource configuration.
     * </p>
     * 
     * @return The custom domain name of the resource configuration.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The status of the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource configuration.
     * @see ResourceConfigurationStatus
     */
    public final ResourceConfigurationStatus status() {
        return ResourceConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource configuration.
     * @see ResourceConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The resource configuration.
     * </p>
     * 
     * @return The resource configuration.
     */
    public final ResourceConfigurationDefinition resourceConfigurationDefinition() {
        return resourceConfigurationDefinition;
    }

    /**
     * <p>
     * The date and time that the resource configuration was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the resource configuration was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Indicates whether the resource configuration was created and is managed by Amazon.
     * </p>
     * 
     * @return Indicates whether the resource configuration was created and is managed by Amazon.
     */
    public final Boolean amazonManaged() {
        return amazonManaged;
    }

    /**
     * <p>
     * The reason the create-resource-configuration request failed.
     * </p>
     * 
     * @return The reason the create-resource-configuration request failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The most recent date and time that the resource configuration was updated, in ISO-8601 format.
     * </p>
     * 
     * @return The most recent date and time that the resource configuration was updated, in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The domain verification ID.
     * </p>
     * 
     * @return The domain verification ID.
     */
    public final String domainVerificationId() {
        return domainVerificationId;
    }

    /**
     * <p>
     * The ARN of the domain verification.
     * </p>
     * 
     * @return The ARN of the domain verification.
     */
    public final String domainVerificationArn() {
        return domainVerificationArn;
    }

    /**
     * <p>
     * The domain verification status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainVerificationStatus} will return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #domainVerificationStatusAsString}.
     * </p>
     * 
     * @return The domain verification status.
     * @see VerificationStatus
     */
    public final VerificationStatus domainVerificationStatus() {
        return VerificationStatus.fromValue(domainVerificationStatus);
    }

    /**
     * <p>
     * The domain verification status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainVerificationStatus} will return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #domainVerificationStatusAsString}.
     * </p>
     * 
     * @return The domain verification status.
     * @see VerificationStatus
     */
    public final String domainVerificationStatusAsString() {
        return domainVerificationStatus;
    }

    /**
     * <p>
     * (GROUP) The group domain for a group resource configuration. Any domains that you create for the child resource
     * are subdomains of the group domain. Child resources inherit the verification status of the domain.
     * </p>
     * 
     * @return (GROUP) The group domain for a group resource configuration. Any domains that you create for the child
     *         resource are subdomains of the group domain. Child resources inherit the verification status of the
     *         domain.
     */
    public final String groupDomain() {
        return groupDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allowAssociationToShareableServiceNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(amazonManaged());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(domainVerificationId());
        hashCode = 31 * hashCode + Objects.hashCode(domainVerificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainVerificationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigurationResponse)) {
            return false;
        }
        GetResourceConfigurationResponse other = (GetResourceConfigurationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(resourceGatewayId(), other.resourceGatewayId())
                && Objects.equals(resourceConfigurationGroupId(), other.resourceConfigurationGroupId())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(allowAssociationToShareableServiceNetwork(), other.allowAssociationToShareableServiceNetwork())
                && hasPortRanges() == other.hasPortRanges() && Objects.equals(portRanges(), other.portRanges())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(customDomainName(), other.customDomainName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resourceConfigurationDefinition(), other.resourceConfigurationDefinition())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(amazonManaged(), other.amazonManaged())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(domainVerificationId(), other.domainVerificationId())
                && Objects.equals(domainVerificationArn(), other.domainVerificationArn())
                && Objects.equals(domainVerificationStatusAsString(), other.domainVerificationStatusAsString())
                && Objects.equals(groupDomain(), other.groupDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceConfigurationResponse").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("ResourceGatewayId", resourceGatewayId())
                .add("ResourceConfigurationGroupId", resourceConfigurationGroupId()).add("Type", typeAsString())
                .add("AllowAssociationToShareableServiceNetwork", allowAssociationToShareableServiceNetwork())
                .add("PortRanges", hasPortRanges() ? portRanges() : null).add("Protocol", protocolAsString())
                .add("CustomDomainName", customDomainName()).add("Status", statusAsString())
                .add("ResourceConfigurationDefinition", resourceConfigurationDefinition()).add("CreatedAt", createdAt())
                .add("AmazonManaged", amazonManaged()).add("FailureReason", failureReason())
                .add("LastUpdatedAt", lastUpdatedAt()).add("DomainVerificationId", domainVerificationId())
                .add("DomainVerificationArn", domainVerificationArn())
                .add("DomainVerificationStatus", domainVerificationStatusAsString()).add("GroupDomain", groupDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "resourceGatewayId":
            return Optional.ofNullable(clazz.cast(resourceGatewayId()));
        case "resourceConfigurationGroupId":
            return Optional.ofNullable(clazz.cast(resourceConfigurationGroupId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "allowAssociationToShareableServiceNetwork":
            return Optional.ofNullable(clazz.cast(allowAssociationToShareableServiceNetwork()));
        case "portRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "resourceConfigurationDefinition":
            return Optional.ofNullable(clazz.cast(resourceConfigurationDefinition()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "amazonManaged":
            return Optional.ofNullable(clazz.cast(amazonManaged()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "domainVerificationId":
            return Optional.ofNullable(clazz.cast(domainVerificationId()));
        case "domainVerificationArn":
            return Optional.ofNullable(clazz.cast(domainVerificationArn()));
        case "domainVerificationStatus":
            return Optional.ofNullable(clazz.cast(domainVerificationStatusAsString()));
        case "groupDomain":
            return Optional.ofNullable(clazz.cast(groupDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("resourceGatewayId", RESOURCE_GATEWAY_ID_FIELD);
        map.put("resourceConfigurationGroupId", RESOURCE_CONFIGURATION_GROUP_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("allowAssociationToShareableServiceNetwork", ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD);
        map.put("portRanges", PORT_RANGES_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resourceConfigurationDefinition", RESOURCE_CONFIGURATION_DEFINITION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("amazonManaged", AMAZON_MANAGED_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("domainVerificationId", DOMAIN_VERIFICATION_ID_FIELD);
        map.put("domainVerificationArn", DOMAIN_VERIFICATION_ARN_FIELD);
        map.put("domainVerificationStatus", DOMAIN_VERIFICATION_STATUS_FIELD);
        map.put("groupDomain", GROUP_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceConfigurationResponse, T> g) {
        return obj -> g.apply((GetResourceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceConfigurationResponse> {
        /**
         * <p>
         * The ID of the resource configuration.
         * </p>
         * 
         * @param id
         *        The ID of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the resource configuration.
         * </p>
         * 
         * @param name
         *        The name of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource configuration.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the resource gateway used to connect to the resource configuration in a given VPC. You can specify
         * the resource gateway identifier only for resource configurations with type SINGLE, GROUP, or ARN.
         * </p>
         * 
         * @param resourceGatewayId
         *        The ID of the resource gateway used to connect to the resource configuration in a given VPC. You can
         *        specify the resource gateway identifier only for resource configurations with type SINGLE, GROUP, or
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGatewayId(String resourceGatewayId);

        /**
         * <p>
         * The ID of the group resource configuration.
         * </p>
         * 
         * @param resourceConfigurationGroupId
         *        The ID of the group resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationGroupId(String resourceConfigurationGroupId);

        /**
         * <p>
         * The type of resource configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUP</code> - A group of resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARN</code> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUP</code> - A group of resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARN</code> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUP</code> - A group of resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARN</code> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUP</code> - A group of resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARN</code> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(ResourceConfigurationType type);

        /**
         * <p>
         * Specifies whether the resource configuration is associated with a sharable service network.
         * </p>
         * 
         * @param allowAssociationToShareableServiceNetwork
         *        Specifies whether the resource configuration is associated with a sharable service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork);

        /**
         * <p>
         * The TCP port ranges that a consumer can use to access a resource configuration. You can separate port ranges
         * with a comma. Example: 1-65535 or 1,2,22-30
         * </p>
         * 
         * @param portRanges
         *        The TCP port ranges that a consumer can use to access a resource configuration. You can separate port
         *        ranges with a comma. Example: 1-65535 or 1,2,22-30
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<String> portRanges);

        /**
         * <p>
         * The TCP port ranges that a consumer can use to access a resource configuration. You can separate port ranges
         * with a comma. Example: 1-65535 or 1,2,22-30
         * </p>
         * 
         * @param portRanges
         *        The TCP port ranges that a consumer can use to access a resource configuration. You can separate port
         *        ranges with a comma. Example: 1-65535 or 1,2,22-30
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(String... portRanges);

        /**
         * <p>
         * The TCP protocol accepted by the specified resource configuration.
         * </p>
         * 
         * @param protocol
         *        The TCP protocol accepted by the specified resource configuration.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The TCP protocol accepted by the specified resource configuration.
         * </p>
         * 
         * @param protocol
         *        The TCP protocol accepted by the specified resource configuration.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocol(ProtocolType protocol);

        /**
         * <p>
         * The custom domain name of the resource configuration.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The status of the resource configuration.
         * </p>
         * 
         * @param status
         *        The status of the resource configuration.
         * @see ResourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the resource configuration.
         * </p>
         * 
         * @param status
         *        The status of the resource configuration.
         * @see ResourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationStatus
         */
        Builder status(ResourceConfigurationStatus status);

        /**
         * <p>
         * The resource configuration.
         * </p>
         * 
         * @param resourceConfigurationDefinition
         *        The resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition);

        /**
         * <p>
         * The resource configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceConfigurationDefinition.Builder}
         * avoiding the need to create one manually via {@link ResourceConfigurationDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceConfigurationDefinition.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #resourceConfigurationDefinition(ResourceConfigurationDefinition)}.
         * 
         * @param resourceConfigurationDefinition
         *        a consumer that will call methods on {@link ResourceConfigurationDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfigurationDefinition(ResourceConfigurationDefinition)
         */
        default Builder resourceConfigurationDefinition(
                Consumer<ResourceConfigurationDefinition.Builder> resourceConfigurationDefinition) {
            return resourceConfigurationDefinition(ResourceConfigurationDefinition.builder()
                    .applyMutation(resourceConfigurationDefinition).build());
        }

        /**
         * <p>
         * The date and time that the resource configuration was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the resource configuration was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Indicates whether the resource configuration was created and is managed by Amazon.
         * </p>
         * 
         * @param amazonManaged
         *        Indicates whether the resource configuration was created and is managed by Amazon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonManaged(Boolean amazonManaged);

        /**
         * <p>
         * The reason the create-resource-configuration request failed.
         * </p>
         * 
         * @param failureReason
         *        The reason the create-resource-configuration request failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The most recent date and time that the resource configuration was updated, in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The most recent date and time that the resource configuration was updated, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The domain verification ID.
         * </p>
         * 
         * @param domainVerificationId
         *        The domain verification ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainVerificationId(String domainVerificationId);

        /**
         * <p>
         * The ARN of the domain verification.
         * </p>
         * 
         * @param domainVerificationArn
         *        The ARN of the domain verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainVerificationArn(String domainVerificationArn);

        /**
         * <p>
         * The domain verification status.
         * </p>
         * 
         * @param domainVerificationStatus
         *        The domain verification status.
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder domainVerificationStatus(String domainVerificationStatus);

        /**
         * <p>
         * The domain verification status.
         * </p>
         * 
         * @param domainVerificationStatus
         *        The domain verification status.
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder domainVerificationStatus(VerificationStatus domainVerificationStatus);

        /**
         * <p>
         * (GROUP) The group domain for a group resource configuration. Any domains that you create for the child
         * resource are subdomains of the group domain. Child resources inherit the verification status of the domain.
         * </p>
         * 
         * @param groupDomain
         *        (GROUP) The group domain for a group resource configuration. Any domains that you create for the child
         *        resource are subdomains of the group domain. Child resources inherit the verification status of the
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDomain(String groupDomain);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String resourceGatewayId;

        private String resourceConfigurationGroupId;

        private String type;

        private Boolean allowAssociationToShareableServiceNetwork;

        private List<String> portRanges = DefaultSdkAutoConstructList.getInstance();

        private String protocol;

        private String customDomainName;

        private String status;

        private ResourceConfigurationDefinition resourceConfigurationDefinition;

        private Instant createdAt;

        private Boolean amazonManaged;

        private String failureReason;

        private Instant lastUpdatedAt;

        private String domainVerificationId;

        private String domainVerificationArn;

        private String domainVerificationStatus;

        private String groupDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigurationResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            arn(model.arn);
            resourceGatewayId(model.resourceGatewayId);
            resourceConfigurationGroupId(model.resourceConfigurationGroupId);
            type(model.type);
            allowAssociationToShareableServiceNetwork(model.allowAssociationToShareableServiceNetwork);
            portRanges(model.portRanges);
            protocol(model.protocol);
            customDomainName(model.customDomainName);
            status(model.status);
            resourceConfigurationDefinition(model.resourceConfigurationDefinition);
            createdAt(model.createdAt);
            amazonManaged(model.amazonManaged);
            failureReason(model.failureReason);
            lastUpdatedAt(model.lastUpdatedAt);
            domainVerificationId(model.domainVerificationId);
            domainVerificationArn(model.domainVerificationArn);
            domainVerificationStatus(model.domainVerificationStatus);
            groupDomain(model.groupDomain);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResourceGatewayId() {
            return resourceGatewayId;
        }

        public final void setResourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
        }

        @Override
        public final Builder resourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
            return this;
        }

        public final String getResourceConfigurationGroupId() {
            return resourceConfigurationGroupId;
        }

        public final void setResourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
        }

        @Override
        public final Builder resourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getAllowAssociationToShareableServiceNetwork() {
            return allowAssociationToShareableServiceNetwork;
        }

        public final void setAllowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
        }

        @Override
        public final Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
            return this;
        }

        public final Collection<String> getPortRanges() {
            if (portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return portRanges;
        }

        public final void setPortRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(String... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolType protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ResourceConfigurationDefinition.Builder getResourceConfigurationDefinition() {
            return resourceConfigurationDefinition != null ? resourceConfigurationDefinition.toBuilder() : null;
        }

        public final void setResourceConfigurationDefinition(
                ResourceConfigurationDefinition.BuilderImpl resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition != null ? resourceConfigurationDefinition
                    .build() : null;
        }

        @Override
        public final Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getAmazonManaged() {
            return amazonManaged;
        }

        public final void setAmazonManaged(Boolean amazonManaged) {
            this.amazonManaged = amazonManaged;
        }

        @Override
        public final Builder amazonManaged(Boolean amazonManaged) {
            this.amazonManaged = amazonManaged;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getDomainVerificationId() {
            return domainVerificationId;
        }

        public final void setDomainVerificationId(String domainVerificationId) {
            this.domainVerificationId = domainVerificationId;
        }

        @Override
        public final Builder domainVerificationId(String domainVerificationId) {
            this.domainVerificationId = domainVerificationId;
            return this;
        }

        public final String getDomainVerificationArn() {
            return domainVerificationArn;
        }

        public final void setDomainVerificationArn(String domainVerificationArn) {
            this.domainVerificationArn = domainVerificationArn;
        }

        @Override
        public final Builder domainVerificationArn(String domainVerificationArn) {
            this.domainVerificationArn = domainVerificationArn;
            return this;
        }

        public final String getDomainVerificationStatus() {
            return domainVerificationStatus;
        }

        public final void setDomainVerificationStatus(String domainVerificationStatus) {
            this.domainVerificationStatus = domainVerificationStatus;
        }

        @Override
        public final Builder domainVerificationStatus(String domainVerificationStatus) {
            this.domainVerificationStatus = domainVerificationStatus;
            return this;
        }

        @Override
        public final Builder domainVerificationStatus(VerificationStatus domainVerificationStatus) {
            this.domainVerificationStatus(domainVerificationStatus == null ? null : domainVerificationStatus.toString());
            return this;
        }

        public final String getGroupDomain() {
            return groupDomain;
        }

        public final void setGroupDomain(String groupDomain) {
            this.groupDomain = groupDomain;
        }

        @Override
        public final Builder groupDomain(String groupDomain) {
            this.groupDomain = groupDomain;
            return this;
        }

        @Override
        public GetResourceConfigurationResponse build() {
            return new GetResourceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
