/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourceEndpointAssociationResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<DeleteResourceEndpointAssociationResponse.Builder, DeleteResourceEndpointAssociationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DeleteResourceEndpointAssociationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DeleteResourceEndpointAssociationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationId")
            .getter(getter(DeleteResourceEndpointAssociationResponse::resourceConfigurationId))
            .setter(setter(Builder::resourceConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationId").build())
            .build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationArn")
            .getter(getter(DeleteResourceEndpointAssociationResponse::resourceConfigurationArn))
            .setter(setter(Builder::resourceConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationArn").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointId").getter(getter(DeleteResourceEndpointAssociationResponse::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            RESOURCE_CONFIGURATION_ID_FIELD, RESOURCE_CONFIGURATION_ARN_FIELD, VPC_ENDPOINT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String resourceConfigurationId;

    private final String resourceConfigurationArn;

    private final String vpcEndpointId;

    private DeleteResourceEndpointAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.resourceConfigurationId = builder.resourceConfigurationId;
        this.resourceConfigurationArn = builder.resourceConfigurationArn;
        this.vpcEndpointId = builder.vpcEndpointId;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the resource configuration.
     * </p>
     * 
     * @return The ID of the resource configuration.
     */
    public final String resourceConfigurationId() {
        return resourceConfigurationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource configuration associated with the VPC endpoint of type resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource configuration associated with the VPC endpoint of type
     *         resource.
     */
    public final String resourceConfigurationArn() {
        return resourceConfigurationArn;
    }

    /**
     * <p>
     * The ID of the resource VPC endpoint that is associated with the resource configuration.
     * </p>
     * 
     * @return The ID of the resource VPC endpoint that is associated with the resource configuration.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourceEndpointAssociationResponse)) {
            return false;
        }
        DeleteResourceEndpointAssociationResponse other = (DeleteResourceEndpointAssociationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(resourceConfigurationId(), other.resourceConfigurationId())
                && Objects.equals(resourceConfigurationArn(), other.resourceConfigurationArn())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourceEndpointAssociationResponse").add("Id", id()).add("Arn", arn())
                .add("ResourceConfigurationId", resourceConfigurationId())
                .add("ResourceConfigurationArn", resourceConfigurationArn()).add("VpcEndpointId", vpcEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "resourceConfigurationId":
            return Optional.ofNullable(clazz.cast(resourceConfigurationId()));
        case "resourceConfigurationArn":
            return Optional.ofNullable(clazz.cast(resourceConfigurationArn()));
        case "vpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("resourceConfigurationId", RESOURCE_CONFIGURATION_ID_FIELD);
        map.put("resourceConfigurationArn", RESOURCE_CONFIGURATION_ARN_FIELD);
        map.put("vpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourceEndpointAssociationResponse, T> g) {
        return obj -> g.apply((DeleteResourceEndpointAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteResourceEndpointAssociationResponse> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param id
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the resource configuration.
         * </p>
         * 
         * @param resourceConfigurationId
         *        The ID of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationId(String resourceConfigurationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource configuration associated with the VPC endpoint of type
         * resource.
         * </p>
         * 
         * @param resourceConfigurationArn
         *        The Amazon Resource Name (ARN) of the resource configuration associated with the VPC endpoint of type
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationArn(String resourceConfigurationArn);

        /**
         * <p>
         * The ID of the resource VPC endpoint that is associated with the resource configuration.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the resource VPC endpoint that is associated with the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String resourceConfigurationId;

        private String resourceConfigurationArn;

        private String vpcEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourceEndpointAssociationResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            resourceConfigurationId(model.resourceConfigurationId);
            resourceConfigurationArn(model.resourceConfigurationArn);
            vpcEndpointId(model.vpcEndpointId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResourceConfigurationId() {
            return resourceConfigurationId;
        }

        public final void setResourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
        }

        @Override
        public final Builder resourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
            return this;
        }

        public final String getResourceConfigurationArn() {
            return resourceConfigurationArn;
        }

        public final void setResourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
        }

        @Override
        public final Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        @Override
        public DeleteResourceEndpointAssociationResponse build() {
            return new DeleteResourceEndpointAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
