/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourceEndpointAssociationRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<DeleteResourceEndpointAssociationRequest.Builder, DeleteResourceEndpointAssociationRequest> {
    private static final SdkField<String> RESOURCE_ENDPOINT_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceEndpointAssociationIdentifier")
            .getter(getter(DeleteResourceEndpointAssociationRequest::resourceEndpointAssociationIdentifier))
            .setter(setter(Builder::resourceEndpointAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceEndpointAssociationIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOURCE_ENDPOINT_ASSOCIATION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceEndpointAssociationIdentifier;

    private DeleteResourceEndpointAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceEndpointAssociationIdentifier = builder.resourceEndpointAssociationIdentifier;
    }

    /**
     * <p>
     * The ID or ARN of the association.
     * </p>
     * 
     * @return The ID or ARN of the association.
     */
    public final String resourceEndpointAssociationIdentifier() {
        return resourceEndpointAssociationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceEndpointAssociationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourceEndpointAssociationRequest)) {
            return false;
        }
        DeleteResourceEndpointAssociationRequest other = (DeleteResourceEndpointAssociationRequest) obj;
        return Objects.equals(resourceEndpointAssociationIdentifier(), other.resourceEndpointAssociationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourceEndpointAssociationRequest")
                .add("ResourceEndpointAssociationIdentifier", resourceEndpointAssociationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceEndpointAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(resourceEndpointAssociationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceEndpointAssociationIdentifier", RESOURCE_ENDPOINT_ASSOCIATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourceEndpointAssociationRequest, T> g) {
        return obj -> g.apply((DeleteResourceEndpointAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteResourceEndpointAssociationRequest> {
        /**
         * <p>
         * The ID or ARN of the association.
         * </p>
         * 
         * @param resourceEndpointAssociationIdentifier
         *        The ID or ARN of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEndpointAssociationIdentifier(String resourceEndpointAssociationIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String resourceEndpointAssociationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourceEndpointAssociationRequest model) {
            super(model);
            resourceEndpointAssociationIdentifier(model.resourceEndpointAssociationIdentifier);
        }

        public final String getResourceEndpointAssociationIdentifier() {
            return resourceEndpointAssociationIdentifier;
        }

        public final void setResourceEndpointAssociationIdentifier(String resourceEndpointAssociationIdentifier) {
            this.resourceEndpointAssociationIdentifier = resourceEndpointAssociationIdentifier;
        }

        @Override
        public final Builder resourceEndpointAssociationIdentifier(String resourceEndpointAssociationIdentifier) {
            this.resourceEndpointAssociationIdentifier = resourceEndpointAssociationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourceEndpointAssociationRequest build() {
            return new DeleteResourceEndpointAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
