/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTargetGroupResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<CreateTargetGroupResponse.Builder, CreateTargetGroupResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateTargetGroupResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateTargetGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateTargetGroupResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateTargetGroupResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<TargetGroupConfig> CONFIG_FIELD = SdkField
            .<TargetGroupConfig> builder(MarshallingType.SDK_POJO).memberName("config")
            .getter(getter(CreateTargetGroupResponse::config)).setter(setter(Builder::config))
            .constructor(TargetGroupConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("config").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateTargetGroupResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, TYPE_FIELD, CONFIG_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String name;

    private final String type;

    private final TargetGroupConfig config;

    private final String status;

    private CreateTargetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.config = builder.config;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the target group.
     * </p>
     * 
     * @return The ID of the target group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the target group.
     * </p>
     * 
     * @return The name of the target group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of target group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TargetGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of target group.
     * @see TargetGroupType
     */
    public final TargetGroupType type() {
        return TargetGroupType.fromValue(type);
    }

    /**
     * <p>
     * The type of target group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TargetGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of target group.
     * @see TargetGroupType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The target group configuration.
     * </p>
     * 
     * @return The target group configuration.
     */
    public final TargetGroupConfig config() {
        return config;
    }

    /**
     * <p>
     * The status. You can retry the operation if the status is <code>CREATE_FAILED</code>. However, if you retry it
     * while the status is <code>CREATE_IN_PROGRESS</code>, there is no change in the status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status. You can retry the operation if the status is <code>CREATE_FAILED</code>. However, if you
     *         retry it while the status is <code>CREATE_IN_PROGRESS</code>, there is no change in the status.
     * @see TargetGroupStatus
     */
    public final TargetGroupStatus status() {
        return TargetGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status. You can retry the operation if the status is <code>CREATE_FAILED</code>. However, if you retry it
     * while the status is <code>CREATE_IN_PROGRESS</code>, there is no change in the status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status. You can retry the operation if the status is <code>CREATE_FAILED</code>. However, if you
     *         retry it while the status is <code>CREATE_IN_PROGRESS</code>, there is no change in the status.
     * @see TargetGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTargetGroupResponse)) {
            return false;
        }
        CreateTargetGroupResponse other = (CreateTargetGroupResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(config(), other.config())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTargetGroupResponse").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Type", typeAsString()).add("Config", config()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "config":
            return Optional.ofNullable(clazz.cast(config()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("config", CONFIG_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTargetGroupResponse, T> g) {
        return obj -> g.apply((CreateTargetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTargetGroupResponse> {
        /**
         * <p>
         * The ID of the target group.
         * </p>
         * 
         * @param id
         *        The ID of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the target group.
         * </p>
         * 
         * @param name
         *        The name of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of target group.
         * </p>
         * 
         * @param type
         *        The type of target group.
         * @see TargetGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of target group.
         * </p>
         * 
         * @param type
         *        The type of target group.
         * @see TargetGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupType
         */
        Builder type(TargetGroupType type);

        /**
         * <p>
         * The target group configuration.
         * </p>
         * 
         * @param config
         *        The target group configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(TargetGroupConfig config);

        /**
         * <p>
         * The target group configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetGroupConfig.Builder} avoiding the
         * need to create one manually via {@link TargetGroupConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetGroupConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #config(TargetGroupConfig)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link TargetGroupConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(TargetGroupConfig)
         */
        default Builder config(Consumer<TargetGroupConfig.Builder> config) {
            return config(TargetGroupConfig.builder().applyMutation(config).build());
        }

        /**
         * <p>
         * The status. You can retry the operation if the status is <code>CREATE_FAILED</code>. However, if you retry it
         * while the status is <code>CREATE_IN_PROGRESS</code>, there is no change in the status.
         * </p>
         * 
         * @param status
         *        The status. You can retry the operation if the status is <code>CREATE_FAILED</code>. However, if you
         *        retry it while the status is <code>CREATE_IN_PROGRESS</code>, there is no change in the status.
         * @see TargetGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status. You can retry the operation if the status is <code>CREATE_FAILED</code>. However, if you retry it
         * while the status is <code>CREATE_IN_PROGRESS</code>, there is no change in the status.
         * </p>
         * 
         * @param status
         *        The status. You can retry the operation if the status is <code>CREATE_FAILED</code>. However, if you
         *        retry it while the status is <code>CREATE_IN_PROGRESS</code>, there is no change in the status.
         * @see TargetGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupStatus
         */
        Builder status(TargetGroupStatus status);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String type;

        private TargetGroupConfig config;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTargetGroupResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            name(model.name);
            type(model.type);
            config(model.config);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TargetGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TargetGroupConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        public final void setConfig(TargetGroupConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(TargetGroupConfig config) {
            this.config = config;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateTargetGroupResponse build() {
            return new CreateTargetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
