/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceNetworkVpcAssociationRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<CreateServiceNetworkVpcAssociationRequest.Builder, CreateServiceNetworkVpcAssociationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateServiceNetworkVpcAssociationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> SERVICE_NETWORK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkIdentifier")
            .getter(getter(CreateServiceNetworkVpcAssociationRequest::serviceNetworkIdentifier))
            .setter(setter(Builder::serviceNetworkIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkIdentifier").build())
            .build();

    private static final SdkField<String> VPC_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcIdentifier").getter(getter(CreateServiceNetworkVpcAssociationRequest::vpcIdentifier))
            .setter(setter(Builder::vpcIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcIdentifier").build()).build();

    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("privateDnsEnabled").getter(getter(CreateServiceNetworkVpcAssociationRequest::privateDnsEnabled))
            .setter(setter(Builder::privateDnsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsEnabled").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(CreateServiceNetworkVpcAssociationRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateServiceNetworkVpcAssociationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DnsOptions> DNS_OPTIONS_FIELD = SdkField.<DnsOptions> builder(MarshallingType.SDK_POJO)
            .memberName("dnsOptions").getter(getter(CreateServiceNetworkVpcAssociationRequest::dnsOptions))
            .setter(setter(Builder::dnsOptions)).constructor(DnsOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            SERVICE_NETWORK_IDENTIFIER_FIELD, VPC_IDENTIFIER_FIELD, PRIVATE_DNS_ENABLED_FIELD, SECURITY_GROUP_IDS_FIELD,
            TAGS_FIELD, DNS_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String serviceNetworkIdentifier;

    private final String vpcIdentifier;

    private final Boolean privateDnsEnabled;

    private final List<String> securityGroupIds;

    private final Map<String, String> tags;

    private final DnsOptions dnsOptions;

    private CreateServiceNetworkVpcAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.serviceNetworkIdentifier = builder.serviceNetworkIdentifier;
        this.vpcIdentifier = builder.vpcIdentifier;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.dnsOptions = builder.dnsOptions;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
     * request that completed successfully using the same client token and parameters, the retry succeeds without
     * performing any actions. If the parameters aren't identical, the retry fails.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
     *         retry a request that completed successfully using the same client token and parameters, the retry
     *         succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID or ARN of the service network. You must use an ARN if the resources are in different accounts.
     * </p>
     * 
     * @return The ID or ARN of the service network. You must use an ARN if the resources are in different accounts.
     */
    public final String serviceNetworkIdentifier() {
        return serviceNetworkIdentifier;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcIdentifier() {
        return vpcIdentifier;
    }

    /**
     * <p>
     * Indicates if private DNS is enabled for the VPC association.
     * </p>
     * 
     * @return Indicates if private DNS is enabled for the VPC association.
     */
    public final Boolean privateDnsEnabled() {
        return privateDnsEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups. Security groups aren't added by default. You can add a security group to apply
     * network level controls to control which resources in a VPC are allowed to access the service network and its
     * services. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Control traffic to resources
     * using security groups</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The IDs of the security groups. Security groups aren't added by default. You can add a security group to
     *         apply network level controls to control which resources in a VPC are allowed to access the service
     *         network and its services. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Control traffic to
     *         resources using security groups</a> in the <i>Amazon VPC User Guide</i>.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the association.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * DNS options for the service network VPC association.
     * </p>
     * 
     * @return DNS options for the service network VPC association.
     */
    public final DnsOptions dnsOptions() {
        return dnsOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(vpcIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dnsOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceNetworkVpcAssociationRequest)) {
            return false;
        }
        CreateServiceNetworkVpcAssociationRequest other = (CreateServiceNetworkVpcAssociationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(serviceNetworkIdentifier(), other.serviceNetworkIdentifier())
                && Objects.equals(vpcIdentifier(), other.vpcIdentifier())
                && Objects.equals(privateDnsEnabled(), other.privateDnsEnabled())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(dnsOptions(), other.dnsOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceNetworkVpcAssociationRequest").add("ClientToken", clientToken())
                .add("ServiceNetworkIdentifier", serviceNetworkIdentifier()).add("VpcIdentifier", vpcIdentifier())
                .add("PrivateDnsEnabled", privateDnsEnabled())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("DnsOptions", dnsOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "serviceNetworkIdentifier":
            return Optional.ofNullable(clazz.cast(serviceNetworkIdentifier()));
        case "vpcIdentifier":
            return Optional.ofNullable(clazz.cast(vpcIdentifier()));
        case "privateDnsEnabled":
            return Optional.ofNullable(clazz.cast(privateDnsEnabled()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "dnsOptions":
            return Optional.ofNullable(clazz.cast(dnsOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("serviceNetworkIdentifier", SERVICE_NETWORK_IDENTIFIER_FIELD);
        map.put("vpcIdentifier", VPC_IDENTIFIER_FIELD);
        map.put("privateDnsEnabled", PRIVATE_DNS_ENABLED_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("dnsOptions", DNS_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceNetworkVpcAssociationRequest, T> g) {
        return obj -> g.apply((CreateServiceNetworkVpcAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServiceNetworkVpcAssociationRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
         * request that completed successfully using the same client token and parameters, the retry succeeds without
         * performing any actions. If the parameters aren't identical, the retry fails.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        retry a request that completed successfully using the same client token and parameters, the retry
         *        succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID or ARN of the service network. You must use an ARN if the resources are in different accounts.
         * </p>
         * 
         * @param serviceNetworkIdentifier
         *        The ID or ARN of the service network. You must use an ARN if the resources are in different accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkIdentifier(String serviceNetworkIdentifier);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcIdentifier
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIdentifier(String vpcIdentifier);

        /**
         * <p>
         * Indicates if private DNS is enabled for the VPC association.
         * </p>
         * 
         * @param privateDnsEnabled
         *        Indicates if private DNS is enabled for the VPC association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsEnabled(Boolean privateDnsEnabled);

        /**
         * <p>
         * The IDs of the security groups. Security groups aren't added by default. You can add a security group to
         * apply network level controls to control which resources in a VPC are allowed to access the service network
         * and its services. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Control traffic to resources
         * using security groups</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups. Security groups aren't added by default. You can add a security group
         *        to apply network level controls to control which resources in a VPC are allowed to access the service
         *        network and its services. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Control traffic to
         *        resources using security groups</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of the security groups. Security groups aren't added by default. You can add a security group to
         * apply network level controls to control which resources in a VPC are allowed to access the service network
         * and its services. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Control traffic to resources
         * using security groups</a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups. Security groups aren't added by default. You can add a security group
         *        to apply network level controls to control which resources in a VPC are allowed to access the service
         *        network and its services. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Control traffic to
         *        resources using security groups</a> in the <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The tags for the association.
         * </p>
         * 
         * @param tags
         *        The tags for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * DNS options for the service network VPC association.
         * </p>
         * 
         * @param dnsOptions
         *        DNS options for the service network VPC association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsOptions(DnsOptions dnsOptions);

        /**
         * <p>
         * DNS options for the service network VPC association.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsOptions.Builder} avoiding the need to
         * create one manually via {@link DnsOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #dnsOptions(DnsOptions)}.
         * 
         * @param dnsOptions
         *        a consumer that will call methods on {@link DnsOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsOptions(DnsOptions)
         */
        default Builder dnsOptions(Consumer<DnsOptions.Builder> dnsOptions) {
            return dnsOptions(DnsOptions.builder().applyMutation(dnsOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String serviceNetworkIdentifier;

        private String vpcIdentifier;

        private Boolean privateDnsEnabled;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private DnsOptions dnsOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceNetworkVpcAssociationRequest model) {
            super(model);
            clientToken(model.clientToken);
            serviceNetworkIdentifier(model.serviceNetworkIdentifier);
            vpcIdentifier(model.vpcIdentifier);
            privateDnsEnabled(model.privateDnsEnabled);
            securityGroupIds(model.securityGroupIds);
            tags(model.tags);
            dnsOptions(model.dnsOptions);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getServiceNetworkIdentifier() {
            return serviceNetworkIdentifier;
        }

        public final void setServiceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
        }

        @Override
        public final Builder serviceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
            return this;
        }

        public final String getVpcIdentifier() {
            return vpcIdentifier;
        }

        public final void setVpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
        }

        @Override
        public final Builder vpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
            return this;
        }

        public final Boolean getPrivateDnsEnabled() {
            return privateDnsEnabled;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = CreateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = CreateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final DnsOptions.Builder getDnsOptions() {
            return dnsOptions != null ? dnsOptions.toBuilder() : null;
        }

        public final void setDnsOptions(DnsOptions.BuilderImpl dnsOptions) {
            this.dnsOptions = dnsOptions != null ? dnsOptions.build() : null;
        }

        @Override
        public final Builder dnsOptions(DnsOptions dnsOptions) {
            this.dnsOptions = dnsOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceNetworkVpcAssociationRequest build() {
            return new CreateServiceNetworkVpcAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
