/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkLogType;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessLogSubscriptionResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, GetAccessLogSubscriptionResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetAccessLogSubscriptionResponse.getter(GetAccessLogSubscriptionResponse::id)).setter(GetAccessLogSubscriptionResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetAccessLogSubscriptionResponse.getter(GetAccessLogSubscriptionResponse::arn)).setter(GetAccessLogSubscriptionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(GetAccessLogSubscriptionResponse.getter(GetAccessLogSubscriptionResponse::resourceId)).setter(GetAccessLogSubscriptionResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(GetAccessLogSubscriptionResponse.getter(GetAccessLogSubscriptionResponse::resourceArn)).setter(GetAccessLogSubscriptionResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationArn").getter(GetAccessLogSubscriptionResponse.getter(GetAccessLogSubscriptionResponse::destinationArn)).setter(GetAccessLogSubscriptionResponse.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkLogType").getter(GetAccessLogSubscriptionResponse.getter(GetAccessLogSubscriptionResponse::serviceNetworkLogTypeAsString)).setter(GetAccessLogSubscriptionResponse.setter(Builder::serviceNetworkLogType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkLogType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetAccessLogSubscriptionResponse.getter(GetAccessLogSubscriptionResponse::createdAt)).setter(GetAccessLogSubscriptionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetAccessLogSubscriptionResponse.getter(GetAccessLogSubscriptionResponse::lastUpdatedAt)).setter(GetAccessLogSubscriptionResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, RESOURCE_ID_FIELD, RESOURCE_ARN_FIELD, DESTINATION_ARN_FIELD, SERVICE_NETWORK_LOG_TYPE_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccessLogSubscriptionResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String resourceId;
    private final String resourceArn;
    private final String destinationArn;
    private final String serviceNetworkLogType;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private GetAccessLogSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
        this.destinationArn = builder.destinationArn;
        this.serviceNetworkLogType = builder.serviceNetworkLogType;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final ServiceNetworkLogType serviceNetworkLogType() {
        return ServiceNetworkLogType.fromValue(this.serviceNetworkLogType);
    }

    public final String serviceNetworkLogTypeAsString() {
        return this.serviceNetworkLogType;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkLogTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessLogSubscriptionResponse)) {
            return false;
        }
        GetAccessLogSubscriptionResponse other = (GetAccessLogSubscriptionResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.serviceNetworkLogTypeAsString(), other.serviceNetworkLogTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessLogSubscriptionResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ResourceId", (Object)this.resourceId()).add("ResourceArn", (Object)this.resourceArn()).add("DestinationArn", (Object)this.destinationArn()).add("ServiceNetworkLogType", (Object)this.serviceNetworkLogTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "destinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "serviceNetworkLogType": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkLogTypeAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("destinationArn", DESTINATION_ARN_FIELD);
        map.put("serviceNetworkLogType", SERVICE_NETWORK_LOG_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccessLogSubscriptionResponse, T> g) {
        return obj -> g.apply((GetAccessLogSubscriptionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String resourceId;
        private String resourceArn;
        private String destinationArn;
        private String serviceNetworkLogType;
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessLogSubscriptionResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.resourceId(model.resourceId);
            this.resourceArn(model.resourceArn);
            this.destinationArn(model.destinationArn);
            this.serviceNetworkLogType(model.serviceNetworkLogType);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getServiceNetworkLogType() {
            return this.serviceNetworkLogType;
        }

        public final void setServiceNetworkLogType(String serviceNetworkLogType) {
            this.serviceNetworkLogType = serviceNetworkLogType;
        }

        @Override
        public final Builder serviceNetworkLogType(String serviceNetworkLogType) {
            this.serviceNetworkLogType = serviceNetworkLogType;
            return this;
        }

        @Override
        public final Builder serviceNetworkLogType(ServiceNetworkLogType serviceNetworkLogType) {
            this.serviceNetworkLogType(serviceNetworkLogType == null ? null : serviceNetworkLogType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetAccessLogSubscriptionResponse build() {
            return new GetAccessLogSubscriptionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessLogSubscriptionResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder resourceId(String var1);

        public Builder resourceArn(String var1);

        public Builder destinationArn(String var1);

        public Builder serviceNetworkLogType(String var1);

        public Builder serviceNetworkLogType(ServiceNetworkLogType var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

