/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.vpclattice.model.ArnResource;
import software.amazon.awssdk.services.vpclattice.model.DnsResource;
import software.amazon.awssdk.services.vpclattice.model.IpResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceConfigurationDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceConfigurationDefinition> {
    private static final SdkField<ArnResource> ARN_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("arnResource").getter(ResourceConfigurationDefinition.getter(ResourceConfigurationDefinition::arnResource)).setter(ResourceConfigurationDefinition.setter(Builder::arnResource)).constructor(ArnResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arnResource").build()}).build();
    private static final SdkField<DnsResource> DNS_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsResource").getter(ResourceConfigurationDefinition.getter(ResourceConfigurationDefinition::dnsResource)).setter(ResourceConfigurationDefinition.setter(Builder::dnsResource)).constructor(DnsResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsResource").build()}).build();
    private static final SdkField<IpResource> IP_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ipResource").getter(ResourceConfigurationDefinition.getter(ResourceConfigurationDefinition::ipResource)).setter(ResourceConfigurationDefinition.setter(Builder::ipResource)).constructor(IpResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_RESOURCE_FIELD, DNS_RESOURCE_FIELD, IP_RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceConfigurationDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ArnResource arnResource;
    private final DnsResource dnsResource;
    private final IpResource ipResource;
    private final Type type;

    private ResourceConfigurationDefinition(BuilderImpl builder) {
        this.arnResource = builder.arnResource;
        this.dnsResource = builder.dnsResource;
        this.ipResource = builder.ipResource;
        this.type = builder.type;
    }

    public final ArnResource arnResource() {
        return this.arnResource;
    }

    public final DnsResource dnsResource() {
        return this.dnsResource;
    }

    public final IpResource ipResource() {
        return this.ipResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arnResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfigurationDefinition)) {
            return false;
        }
        ResourceConfigurationDefinition other = (ResourceConfigurationDefinition)obj;
        return Objects.equals(this.arnResource(), other.arnResource()) && Objects.equals(this.dnsResource(), other.dnsResource()) && Objects.equals(this.ipResource(), other.ipResource());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceConfigurationDefinition").add("ArnResource", (Object)this.arnResource()).add("DnsResource", (Object)this.dnsResource()).add("IpResource", (Object)this.ipResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arnResource": {
                return Optional.ofNullable(clazz.cast(this.arnResource()));
            }
            case "dnsResource": {
                return Optional.ofNullable(clazz.cast(this.dnsResource()));
            }
            case "ipResource": {
                return Optional.ofNullable(clazz.cast(this.ipResource()));
            }
        }
        return Optional.empty();
    }

    public static ResourceConfigurationDefinition fromArnResource(ArnResource arnResource) {
        return (ResourceConfigurationDefinition)ResourceConfigurationDefinition.builder().arnResource(arnResource).build();
    }

    public static ResourceConfigurationDefinition fromArnResource(Consumer<ArnResource.Builder> arnResource) {
        ArnResource.Builder builder = ArnResource.builder();
        arnResource.accept(builder);
        return ResourceConfigurationDefinition.fromArnResource((ArnResource)builder.build());
    }

    public static ResourceConfigurationDefinition fromDnsResource(DnsResource dnsResource) {
        return (ResourceConfigurationDefinition)ResourceConfigurationDefinition.builder().dnsResource(dnsResource).build();
    }

    public static ResourceConfigurationDefinition fromDnsResource(Consumer<DnsResource.Builder> dnsResource) {
        DnsResource.Builder builder = DnsResource.builder();
        dnsResource.accept(builder);
        return ResourceConfigurationDefinition.fromDnsResource((DnsResource)builder.build());
    }

    public static ResourceConfigurationDefinition fromIpResource(IpResource ipResource) {
        return (ResourceConfigurationDefinition)ResourceConfigurationDefinition.builder().ipResource(ipResource).build();
    }

    public static ResourceConfigurationDefinition fromIpResource(Consumer<IpResource.Builder> ipResource) {
        IpResource.Builder builder = IpResource.builder();
        ipResource.accept(builder);
        return ResourceConfigurationDefinition.fromIpResource((IpResource)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arnResource", ARN_RESOURCE_FIELD);
        map.put("dnsResource", DNS_RESOURCE_FIELD);
        map.put("ipResource", IP_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfigurationDefinition, T> g) {
        return obj -> g.apply((ResourceConfigurationDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ARN_RESOURCE,
        DNS_RESOURCE,
        IP_RESOURCE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ArnResource arnResource;
        private DnsResource dnsResource;
        private IpResource ipResource;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfigurationDefinition model) {
            this.arnResource(model.arnResource);
            this.dnsResource(model.dnsResource);
            this.ipResource(model.ipResource);
        }

        public final ArnResource.Builder getArnResource() {
            return this.arnResource != null ? this.arnResource.toBuilder() : null;
        }

        public final void setArnResource(ArnResource.BuilderImpl arnResource) {
            ArnResource oldValue = this.arnResource;
            this.arnResource = arnResource != null ? arnResource.build() : null;
            this.handleUnionValueChange(Type.ARN_RESOURCE, oldValue, this.arnResource);
        }

        @Override
        public final Builder arnResource(ArnResource arnResource) {
            ArnResource oldValue = this.arnResource;
            this.arnResource = arnResource;
            this.handleUnionValueChange(Type.ARN_RESOURCE, oldValue, this.arnResource);
            return this;
        }

        public final DnsResource.Builder getDnsResource() {
            return this.dnsResource != null ? this.dnsResource.toBuilder() : null;
        }

        public final void setDnsResource(DnsResource.BuilderImpl dnsResource) {
            DnsResource oldValue = this.dnsResource;
            this.dnsResource = dnsResource != null ? dnsResource.build() : null;
            this.handleUnionValueChange(Type.DNS_RESOURCE, oldValue, this.dnsResource);
        }

        @Override
        public final Builder dnsResource(DnsResource dnsResource) {
            DnsResource oldValue = this.dnsResource;
            this.dnsResource = dnsResource;
            this.handleUnionValueChange(Type.DNS_RESOURCE, oldValue, this.dnsResource);
            return this;
        }

        public final IpResource.Builder getIpResource() {
            return this.ipResource != null ? this.ipResource.toBuilder() : null;
        }

        public final void setIpResource(IpResource.BuilderImpl ipResource) {
            IpResource oldValue = this.ipResource;
            this.ipResource = ipResource != null ? ipResource.build() : null;
            this.handleUnionValueChange(Type.IP_RESOURCE, oldValue, this.ipResource);
        }

        @Override
        public final Builder ipResource(IpResource ipResource) {
            IpResource oldValue = this.ipResource;
            this.ipResource = ipResource;
            this.handleUnionValueChange(Type.IP_RESOURCE, oldValue, this.ipResource);
            return this;
        }

        public ResourceConfigurationDefinition build() {
            return new ResourceConfigurationDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceConfigurationDefinition> {
        public Builder arnResource(ArnResource var1);

        default public Builder arnResource(Consumer<ArnResource.Builder> arnResource) {
            return this.arnResource((ArnResource)((ArnResource.Builder)ArnResource.builder().applyMutation(arnResource)).build());
        }

        public Builder dnsResource(DnsResource var1);

        default public Builder dnsResource(Consumer<DnsResource.Builder> dnsResource) {
            return this.dnsResource((DnsResource)((DnsResource.Builder)DnsResource.builder().applyMutation(dnsResource)).build());
        }

        public Builder ipResource(IpResource var1);

        default public Builder ipResource(Consumer<IpResource.Builder> ipResource) {
            return this.ipResource((IpResource)((IpResource.Builder)IpResource.builder().applyMutation(ipResource)).build());
        }
    }
}

