/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.AccessLogSubscriptionSummary;
import software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse;

public class ListAccessLogSubscriptionsPublisher
implements SdkPublisher<ListAccessLogSubscriptionsResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListAccessLogSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessLogSubscriptionsPublisher(VpcLatticeAsyncClient client, ListAccessLogSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessLogSubscriptionsPublisher(VpcLatticeAsyncClient client, ListAccessLogSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessLogSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessLogSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessLogSubscriptionSummary> items() {
        Function<ListAccessLogSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessLogSubscriptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessLogSubscriptionsResponseFetcher
    implements AsyncPageFetcher<ListAccessLogSubscriptionsResponse> {
        private ListAccessLogSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessLogSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessLogSubscriptionsResponse> nextPage(ListAccessLogSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessLogSubscriptionsPublisher.this.client.listAccessLogSubscriptions(ListAccessLogSubscriptionsPublisher.this.firstRequest);
            }
            return ListAccessLogSubscriptionsPublisher.this.client.listAccessLogSubscriptions((ListAccessLogSubscriptionsRequest)((Object)ListAccessLogSubscriptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

