/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ResourceEndpointAssociationSummary;

public class ListResourceEndpointAssociationsPublisher
implements SdkPublisher<ListResourceEndpointAssociationsResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListResourceEndpointAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceEndpointAssociationsPublisher(VpcLatticeAsyncClient client, ListResourceEndpointAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceEndpointAssociationsPublisher(VpcLatticeAsyncClient client, ListResourceEndpointAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceEndpointAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceEndpointAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceEndpointAssociationSummary> items() {
        Function<ListResourceEndpointAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceEndpointAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceEndpointAssociationsResponseFetcher
    implements AsyncPageFetcher<ListResourceEndpointAssociationsResponse> {
        private ListResourceEndpointAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceEndpointAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceEndpointAssociationsResponse> nextPage(ListResourceEndpointAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceEndpointAssociationsPublisher.this.client.listResourceEndpointAssociations(ListResourceEndpointAssociationsPublisher.this.firstRequest);
            }
            return ListResourceEndpointAssociationsPublisher.this.client.listResourceEndpointAssociations((ListResourceEndpointAssociationsRequest)((Object)ListResourceEndpointAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

