/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.DnsEntry;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationStatus;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceNetworkServiceAssociationResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, CreateServiceNetworkServiceAssociationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateServiceNetworkServiceAssociationResponse.getter(CreateServiceNetworkServiceAssociationResponse::arn)).setter(CreateServiceNetworkServiceAssociationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(CreateServiceNetworkServiceAssociationResponse.getter(CreateServiceNetworkServiceAssociationResponse::createdBy)).setter(CreateServiceNetworkServiceAssociationResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDomainName").getter(CreateServiceNetworkServiceAssociationResponse.getter(CreateServiceNetworkServiceAssociationResponse::customDomainName)).setter(CreateServiceNetworkServiceAssociationResponse.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()}).build();
    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsEntry").getter(CreateServiceNetworkServiceAssociationResponse.getter(CreateServiceNetworkServiceAssociationResponse::dnsEntry)).setter(CreateServiceNetworkServiceAssociationResponse.setter(Builder::dnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsEntry").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateServiceNetworkServiceAssociationResponse.getter(CreateServiceNetworkServiceAssociationResponse::id)).setter(CreateServiceNetworkServiceAssociationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateServiceNetworkServiceAssociationResponse.getter(CreateServiceNetworkServiceAssociationResponse::statusAsString)).setter(CreateServiceNetworkServiceAssociationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_BY_FIELD, CUSTOM_DOMAIN_NAME_FIELD, DNS_ENTRY_FIELD, ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateServiceNetworkServiceAssociationResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String createdBy;
    private final String customDomainName;
    private final DnsEntry dnsEntry;
    private final String id;
    private final String status;

    private CreateServiceNetworkServiceAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.customDomainName = builder.customDomainName;
        this.dnsEntry = builder.dnsEntry;
        this.id = builder.id;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    public final DnsEntry dnsEntry() {
        return this.dnsEntry;
    }

    public final String id() {
        return this.id;
    }

    public final ServiceNetworkServiceAssociationStatus status() {
        return ServiceNetworkServiceAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceNetworkServiceAssociationResponse)) {
            return false;
        }
        CreateServiceNetworkServiceAssociationResponse other = (CreateServiceNetworkServiceAssociationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.customDomainName(), other.customDomainName()) && Objects.equals(this.dnsEntry(), other.dnsEntry()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceNetworkServiceAssociationResponse").add("Arn", (Object)this.arn()).add("CreatedBy", (Object)this.createdBy()).add("CustomDomainName", (Object)this.customDomainName()).add("DnsEntry", (Object)this.dnsEntry()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "customDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
            case "dnsEntry": {
                return Optional.ofNullable(clazz.cast(this.dnsEntry()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("dnsEntry", DNS_ENTRY_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceNetworkServiceAssociationResponse, T> g) {
        return obj -> g.apply((CreateServiceNetworkServiceAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String createdBy;
        private String customDomainName;
        private DnsEntry dnsEntry;
        private String id;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceNetworkServiceAssociationResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdBy(model.createdBy);
            this.customDomainName(model.customDomainName);
            this.dnsEntry(model.dnsEntry);
            this.id(model.id);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return this.dnsEntry != null ? this.dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkServiceAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateServiceNetworkServiceAssociationResponse build() {
            return new CreateServiceNetworkServiceAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceNetworkServiceAssociationResponse> {
        public Builder arn(String var1);

        public Builder createdBy(String var1);

        public Builder customDomainName(String var1);

        public Builder dnsEntry(DnsEntry var1);

        default public Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return this.dnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(dnsEntry)).build());
        }

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ServiceNetworkServiceAssociationStatus var1);
    }
}

