/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse;
import software.amazon.awssdk.services.vpclattice.model.ResourceGatewaySummary;

public class ListResourceGatewaysPublisher
implements SdkPublisher<ListResourceGatewaysResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListResourceGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceGatewaysPublisher(VpcLatticeAsyncClient client, ListResourceGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceGatewaysPublisher(VpcLatticeAsyncClient client, ListResourceGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceGatewaySummary> items() {
        Function<ListResourceGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceGatewaysResponseFetcher
    implements AsyncPageFetcher<ListResourceGatewaysResponse> {
        private ListResourceGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceGatewaysResponse> nextPage(ListResourceGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListResourceGatewaysPublisher.this.client.listResourceGateways(ListResourceGatewaysPublisher.this.firstRequest);
            }
            return ListResourceGatewaysPublisher.this.client.listResourceGateways((ListResourceGatewaysRequest)((Object)ListResourceGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

