/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ResourceEndpointAssociationSummary;

public class ListResourceEndpointAssociationsIterable
implements SdkIterable<ListResourceEndpointAssociationsResponse> {
    private final VpcLatticeClient client;
    private final ListResourceEndpointAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceEndpointAssociationsIterable(VpcLatticeClient client, ListResourceEndpointAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceEndpointAssociationsResponseFetcher();
    }

    public Iterator<ListResourceEndpointAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceEndpointAssociationSummary> items() {
        Function<ListResourceEndpointAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceEndpointAssociationsResponseFetcher
    implements SyncPageFetcher<ListResourceEndpointAssociationsResponse> {
        private ListResourceEndpointAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceEndpointAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceEndpointAssociationsResponse nextPage(ListResourceEndpointAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceEndpointAssociationsIterable.this.client.listResourceEndpointAssociations(ListResourceEndpointAssociationsIterable.this.firstRequest);
            }
            return ListResourceEndpointAssociationsIterable.this.client.listResourceEndpointAssociations((ListResourceEndpointAssociationsRequest)((Object)ListResourceEndpointAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

