/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceConfigurationType {
    GROUP("GROUP"),
    CHILD("CHILD"),
    SINGLE("SINGLE"),
    ARN("ARN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceConfigurationType> VALUE_MAP;
    private final String value;

    private ResourceConfigurationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceConfigurationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceConfigurationType> knownValues() {
        EnumSet<ResourceConfigurationType> knownValues = EnumSet.allOf(ResourceConfigurationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceConfigurationType.class, ResourceConfigurationType::toString);
    }
}

