/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.HeaderMatch;
import software.amazon.awssdk.services.vpclattice.model.HeaderMatchListCopier;
import software.amazon.awssdk.services.vpclattice.model.PathMatch;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpMatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpMatch> {
    private static final SdkField<List<HeaderMatch>> HEADER_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("headerMatches").getter(HttpMatch.getter(HttpMatch::headerMatches)).setter(HttpMatch.setter(Builder::headerMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headerMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HeaderMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("method").getter(HttpMatch.getter(HttpMatch::method)).setter(HttpMatch.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()}).build();
    private static final SdkField<PathMatch> PATH_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pathMatch").getter(HttpMatch.getter(HttpMatch::pathMatch)).setter(HttpMatch.setter(Builder::pathMatch)).constructor(PathMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathMatch").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_MATCHES_FIELD, METHOD_FIELD, PATH_MATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("headerMatches", HEADER_MATCHES_FIELD);
            this.put("method", METHOD_FIELD);
            this.put("pathMatch", PATH_MATCH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<HeaderMatch> headerMatches;
    private final String method;
    private final PathMatch pathMatch;

    private HttpMatch(BuilderImpl builder) {
        this.headerMatches = builder.headerMatches;
        this.method = builder.method;
        this.pathMatch = builder.pathMatch;
    }

    public final boolean hasHeaderMatches() {
        return this.headerMatches != null && !(this.headerMatches instanceof SdkAutoConstructList);
    }

    public final List<HeaderMatch> headerMatches() {
        return this.headerMatches;
    }

    public final String method() {
        return this.method;
    }

    public final PathMatch pathMatch() {
        return this.pathMatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaderMatches() ? this.headerMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.method());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathMatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpMatch)) {
            return false;
        }
        HttpMatch other = (HttpMatch)obj;
        return this.hasHeaderMatches() == other.hasHeaderMatches() && Objects.equals(this.headerMatches(), other.headerMatches()) && Objects.equals(this.method(), other.method()) && Objects.equals(this.pathMatch(), other.pathMatch());
    }

    public final String toString() {
        return ToString.builder((String)"HttpMatch").add("HeaderMatches", this.hasHeaderMatches() ? this.headerMatches() : null).add("Method", (Object)this.method()).add("PathMatch", (Object)this.pathMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "headerMatches": {
                return Optional.ofNullable(clazz.cast(this.headerMatches()));
            }
            case "method": {
                return Optional.ofNullable(clazz.cast(this.method()));
            }
            case "pathMatch": {
                return Optional.ofNullable(clazz.cast(this.pathMatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HttpMatch, T> g) {
        return obj -> g.apply((HttpMatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<HeaderMatch> headerMatches = DefaultSdkAutoConstructList.getInstance();
        private String method;
        private PathMatch pathMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpMatch model) {
            this.headerMatches(model.headerMatches);
            this.method(model.method);
            this.pathMatch(model.pathMatch);
        }

        public final List<HeaderMatch.Builder> getHeaderMatches() {
            List<HeaderMatch.Builder> result = HeaderMatchListCopier.copyToBuilder(this.headerMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaderMatches(Collection<HeaderMatch.BuilderImpl> headerMatches) {
            this.headerMatches = HeaderMatchListCopier.copyFromBuilder(headerMatches);
        }

        @Override
        public final Builder headerMatches(Collection<HeaderMatch> headerMatches) {
            this.headerMatches = HeaderMatchListCopier.copy(headerMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerMatches(HeaderMatch ... headerMatches) {
            this.headerMatches(Arrays.asList(headerMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerMatches(Consumer<HeaderMatch.Builder> ... headerMatches) {
            this.headerMatches(Stream.of(headerMatches).map(c -> (HeaderMatch)((HeaderMatch.Builder)HeaderMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final PathMatch.Builder getPathMatch() {
            return this.pathMatch != null ? this.pathMatch.toBuilder() : null;
        }

        public final void setPathMatch(PathMatch.BuilderImpl pathMatch) {
            this.pathMatch = pathMatch != null ? pathMatch.build() : null;
        }

        @Override
        public final Builder pathMatch(PathMatch pathMatch) {
            this.pathMatch = pathMatch;
            return this;
        }

        public HttpMatch build() {
            return new HttpMatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpMatch> {
        public Builder headerMatches(Collection<HeaderMatch> var1);

        public Builder headerMatches(HeaderMatch ... var1);

        public Builder headerMatches(Consumer<HeaderMatch.Builder> ... var1);

        public Builder method(String var1);

        public Builder pathMatch(PathMatch var1);

        default public Builder pathMatch(Consumer<PathMatch.Builder> pathMatch) {
            return this.pathMatch((PathMatch)((PathMatch.Builder)PathMatch.builder().applyMutation(pathMatch)).build());
        }
    }
}

