/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.RuleUpdate;
import software.amazon.awssdk.services.vpclattice.model.RuleUpdateListCopier;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateRuleRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, BatchUpdateRuleRequest> {
    private static final SdkField<String> LISTENER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listenerIdentifier").getter(BatchUpdateRuleRequest.getter(BatchUpdateRuleRequest::listenerIdentifier)).setter(BatchUpdateRuleRequest.setter(Builder::listenerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("listenerIdentifier").build()}).build();
    private static final SdkField<List<RuleUpdate>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(BatchUpdateRuleRequest.getter(BatchUpdateRuleRequest::rules)).setter(BatchUpdateRuleRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceIdentifier").getter(BatchUpdateRuleRequest.getter(BatchUpdateRuleRequest::serviceIdentifier)).setter(BatchUpdateRuleRequest.setter(Builder::serviceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_IDENTIFIER_FIELD, RULES_FIELD, SERVICE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("listenerIdentifier", LISTENER_IDENTIFIER_FIELD);
            this.put("rules", RULES_FIELD);
            this.put("serviceIdentifier", SERVICE_IDENTIFIER_FIELD);
        }
    });
    private final String listenerIdentifier;
    private final List<RuleUpdate> rules;
    private final String serviceIdentifier;

    private BatchUpdateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.listenerIdentifier = builder.listenerIdentifier;
        this.rules = builder.rules;
        this.serviceIdentifier = builder.serviceIdentifier;
    }

    public final String listenerIdentifier() {
        return this.listenerIdentifier;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<RuleUpdate> rules() {
        return this.rules;
    }

    public final String serviceIdentifier() {
        return this.serviceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRuleRequest)) {
            return false;
        }
        BatchUpdateRuleRequest other = (BatchUpdateRuleRequest)((Object)obj);
        return Objects.equals(this.listenerIdentifier(), other.listenerIdentifier()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.serviceIdentifier(), other.serviceIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateRuleRequest").add("ListenerIdentifier", (Object)this.listenerIdentifier()).add("Rules", this.hasRules() ? this.rules() : null).add("ServiceIdentifier", (Object)this.serviceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "listenerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.listenerIdentifier()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "serviceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serviceIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateRuleRequest, T> g) {
        return obj -> g.apply((BatchUpdateRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private String listenerIdentifier;
        private List<RuleUpdate> rules = DefaultSdkAutoConstructList.getInstance();
        private String serviceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateRuleRequest model) {
            super(model);
            this.listenerIdentifier(model.listenerIdentifier);
            this.rules(model.rules);
            this.serviceIdentifier(model.serviceIdentifier);
        }

        public final String getListenerIdentifier() {
            return this.listenerIdentifier;
        }

        public final void setListenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
        }

        @Override
        public final Builder listenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
            return this;
        }

        public final List<RuleUpdate.Builder> getRules() {
            List<RuleUpdate.Builder> result = RuleUpdateListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<RuleUpdate.BuilderImpl> rules) {
            this.rules = RuleUpdateListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<RuleUpdate> rules) {
            this.rules = RuleUpdateListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleUpdate ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleUpdate.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (RuleUpdate)((RuleUpdate.Builder)RuleUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceIdentifier() {
            return this.serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateRuleRequest build() {
            return new BatchUpdateRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateRuleRequest> {
        public Builder listenerIdentifier(String var1);

        public Builder rules(Collection<RuleUpdate> var1);

        public Builder rules(RuleUpdate ... var1);

        public Builder rules(Consumer<RuleUpdate.Builder> ... var1);

        public Builder serviceIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

