/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.Target;
import software.amazon.awssdk.services.vpclattice.model.TargetFailure;
import software.amazon.awssdk.services.vpclattice.model.TargetFailureListCopier;
import software.amazon.awssdk.services.vpclattice.model.TargetListCopier;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterTargetsResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, RegisterTargetsResponse> {
    private static final SdkField<List<Target>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successful").getter(RegisterTargetsResponse.getter(RegisterTargetsResponse::successful)).setter(RegisterTargetsResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TargetFailure>> UNSUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unsuccessful").getter(RegisterTargetsResponse.getter(RegisterTargetsResponse::unsuccessful)).setter(RegisterTargetsResponse.setter(Builder::unsuccessful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unsuccessful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, UNSUCCESSFUL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("successful", SUCCESSFUL_FIELD);
            this.put("unsuccessful", UNSUCCESSFUL_FIELD);
        }
    });
    private final List<Target> successful;
    private final List<TargetFailure> unsuccessful;

    private RegisterTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<Target> successful() {
        return this.successful;
    }

    public final boolean hasUnsuccessful() {
        return this.unsuccessful != null && !(this.unsuccessful instanceof SdkAutoConstructList);
    }

    public final List<TargetFailure> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessful() ? this.unsuccessful() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetsResponse)) {
            return false;
        }
        RegisterTargetsResponse other = (RegisterTargetsResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasUnsuccessful() == other.hasUnsuccessful() && Objects.equals(this.unsuccessful(), other.unsuccessful());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterTargetsResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Unsuccessful", this.hasUnsuccessful() ? this.unsuccessful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "unsuccessful": {
                return Optional.ofNullable(clazz.cast(this.unsuccessful()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTargetsResponse, T> g) {
        return obj -> g.apply((RegisterTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private List<Target> successful = DefaultSdkAutoConstructList.getInstance();
        private List<TargetFailure> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTargetsResponse model) {
            super(model);
            this.successful(model.successful);
            this.unsuccessful(model.unsuccessful);
        }

        public final List<Target.Builder> getSuccessful() {
            List<Target.Builder> result = TargetListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<Target.BuilderImpl> successful) {
            this.successful = TargetListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<Target> successful) {
            this.successful = TargetListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Target ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<Target.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TargetFailure.Builder> getUnsuccessful() {
            List<TargetFailure.Builder> result = TargetFailureListCopier.copyToBuilder(this.unsuccessful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessful(Collection<TargetFailure.BuilderImpl> unsuccessful) {
            this.unsuccessful = TargetFailureListCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public final Builder unsuccessful(Collection<TargetFailure> unsuccessful) {
            this.unsuccessful = TargetFailureListCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(TargetFailure ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<TargetFailure.Builder> ... unsuccessful) {
            this.unsuccessful(Stream.of(unsuccessful).map(c -> (TargetFailure)((TargetFailure.Builder)TargetFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegisterTargetsResponse build() {
            return new RegisterTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterTargetsResponse> {
        public Builder successful(Collection<Target> var1);

        public Builder successful(Target ... var1);

        public Builder successful(Consumer<Target.Builder> ... var1);

        public Builder unsuccessful(Collection<TargetFailure> var1);

        public Builder unsuccessful(TargetFailure ... var1);

        public Builder unsuccessful(Consumer<TargetFailure.Builder> ... var1);
    }
}

