/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListServicesRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServicesResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceSummary;

public class ListServicesIterable
implements SdkIterable<ListServicesResponse> {
    private final VpcLatticeClient client;
    private final ListServicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServicesIterable(VpcLatticeClient client, ListServicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServicesResponseFetcher();
    }

    public Iterator<ListServicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceSummary> items() {
        Function<ListServicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServicesResponseFetcher
    implements SyncPageFetcher<ListServicesResponse> {
        private ListServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServicesResponse nextPage(ListServicesResponse previousPage) {
            if (previousPage == null) {
                return ListServicesIterable.this.client.listServices(ListServicesIterable.this.firstRequest);
            }
            return ListServicesIterable.this.client.listServices((ListServicesRequest)((Object)ListServicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

