/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListRulesRequest;
import software.amazon.awssdk.services.vpclattice.model.ListRulesResponse;
import software.amazon.awssdk.services.vpclattice.model.RuleSummary;

public class ListRulesIterable
implements SdkIterable<ListRulesResponse> {
    private final VpcLatticeClient client;
    private final ListRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRulesIterable(VpcLatticeClient client, ListRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRulesResponseFetcher();
    }

    public Iterator<ListRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RuleSummary> items() {
        Function<ListRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRulesResponseFetcher
    implements SyncPageFetcher<ListRulesResponse> {
        private ListRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRulesResponse nextPage(ListRulesResponse previousPage) {
            if (previousPage == null) {
                return ListRulesIterable.this.client.listRules(ListRulesIterable.this.firstRequest);
            }
            return ListRulesIterable.this.client.listRules((ListRulesRequest)((Object)ListRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

