/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequestTargetsListCopier;
import software.amazon.awssdk.services.vpclattice.model.Target;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterTargetsRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, RegisterTargetsRequest> {
    private static final SdkField<String> TARGET_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetGroupIdentifier").getter(RegisterTargetsRequest.getter(RegisterTargetsRequest::targetGroupIdentifier)).setter(RegisterTargetsRequest.setter(Builder::targetGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("targetGroupIdentifier").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targets").getter(RegisterTargetsRequest.getter(RegisterTargetsRequest::targets)).setter(RegisterTargetsRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_IDENTIFIER_FIELD, TARGETS_FIELD));
    private final String targetGroupIdentifier;
    private final List<Target> targets;

    private RegisterTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.targetGroupIdentifier = builder.targetGroupIdentifier;
        this.targets = builder.targets;
    }

    public final String targetGroupIdentifier() {
        return this.targetGroupIdentifier;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetsRequest)) {
            return false;
        }
        RegisterTargetsRequest other = (RegisterTargetsRequest)((Object)obj);
        return Objects.equals(this.targetGroupIdentifier(), other.targetGroupIdentifier()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterTargetsRequest").add("TargetGroupIdentifier", (Object)this.targetGroupIdentifier()).add("Targets", this.hasTargets() ? this.targets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetGroupIdentifier()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTargetsRequest, T> g) {
        return obj -> g.apply((RegisterTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private String targetGroupIdentifier;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTargetsRequest model) {
            super(model);
            this.targetGroupIdentifier(model.targetGroupIdentifier);
            this.targets(model.targets);
        }

        public final String getTargetGroupIdentifier() {
            return this.targetGroupIdentifier;
        }

        public final void setTargetGroupIdentifier(String targetGroupIdentifier) {
            this.targetGroupIdentifier = targetGroupIdentifier;
        }

        @Override
        public final Builder targetGroupIdentifier(String targetGroupIdentifier) {
            this.targetGroupIdentifier = targetGroupIdentifier;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = RegisterTargetsRequestTargetsListCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = RegisterTargetsRequestTargetsListCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = RegisterTargetsRequestTargetsListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTargetsRequest build() {
            return new RegisterTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterTargetsRequest> {
        public Builder targetGroupIdentifier(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

