/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetGroupType {
    IP("IP"),
    LAMBDA("LAMBDA"),
    INSTANCE("INSTANCE"),
    ALB("ALB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetGroupType> VALUE_MAP;
    private final String value;

    private TargetGroupType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetGroupType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetGroupType> knownValues() {
        EnumSet<TargetGroupType> knownValues = EnumSet.allOf(TargetGroupType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetGroupType.class, TargetGroupType::toString);
    }
}

