/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.vpclattice.DefaultVpcLatticeBaseClientBuilder;
import software.amazon.awssdk.services.vpclattice.DefaultVpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClientBuilder;
import software.amazon.awssdk.services.vpclattice.VpcLatticeServiceClientConfiguration;
import software.amazon.awssdk.services.vpclattice.endpoints.VpcLatticeEndpointProvider;

@SdkInternalApi
final class DefaultVpcLatticeClientBuilder
extends DefaultVpcLatticeBaseClientBuilder<VpcLatticeClientBuilder, VpcLatticeClient>
implements VpcLatticeClientBuilder {
    DefaultVpcLatticeClientBuilder() {
    }

    @Override
    public DefaultVpcLatticeClientBuilder endpointProvider(VpcLatticeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final VpcLatticeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultVpcLatticeClientBuilder.validateClientOptions(clientConfiguration);
        VpcLatticeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultVpcLatticeClient client = new DefaultVpcLatticeClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private VpcLatticeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return VpcLatticeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

