/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.vpclattice.DefaultVpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.DefaultVpcLatticeBaseClientBuilder;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClientBuilder;
import software.amazon.awssdk.services.vpclattice.VpcLatticeServiceClientConfiguration;
import software.amazon.awssdk.services.vpclattice.endpoints.VpcLatticeEndpointProvider;

@SdkInternalApi
final class DefaultVpcLatticeAsyncClientBuilder
extends DefaultVpcLatticeBaseClientBuilder<VpcLatticeAsyncClientBuilder, VpcLatticeAsyncClient>
implements VpcLatticeAsyncClientBuilder {
    DefaultVpcLatticeAsyncClientBuilder() {
    }

    @Override
    public DefaultVpcLatticeAsyncClientBuilder endpointProvider(VpcLatticeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final VpcLatticeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultVpcLatticeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        VpcLatticeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultVpcLatticeAsyncClient client = new DefaultVpcLatticeAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private VpcLatticeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return VpcLatticeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

