/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRuleRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<UpdateRuleRequest.Builder, UpdateRuleRequest> {
    private static final SdkField<RuleAction> ACTION_FIELD = SdkField.<RuleAction> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(UpdateRuleRequest::action)).setter(setter(Builder::action))
            .constructor(RuleAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> LISTENER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listenerIdentifier").getter(getter(UpdateRuleRequest::listenerIdentifier))
            .setter(setter(Builder::listenerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("listenerIdentifier").build()).build();

    private static final SdkField<RuleMatch> MATCH_FIELD = SdkField.<RuleMatch> builder(MarshallingType.SDK_POJO)
            .memberName("match").getter(getter(UpdateRuleRequest::match)).setter(setter(Builder::match))
            .constructor(RuleMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(UpdateRuleRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> RULE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleIdentifier").getter(getter(UpdateRuleRequest::ruleIdentifier))
            .setter(setter(Builder::ruleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ruleIdentifier").build()).build();

    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIdentifier").getter(getter(UpdateRuleRequest::serviceIdentifier))
            .setter(setter(Builder::serviceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            LISTENER_IDENTIFIER_FIELD, MATCH_FIELD, PRIORITY_FIELD, RULE_IDENTIFIER_FIELD, SERVICE_IDENTIFIER_FIELD));

    private final RuleAction action;

    private final String listenerIdentifier;

    private final RuleMatch match;

    private final Integer priority;

    private final String ruleIdentifier;

    private final String serviceIdentifier;

    private UpdateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.listenerIdentifier = builder.listenerIdentifier;
        this.match = builder.match;
        this.priority = builder.priority;
        this.ruleIdentifier = builder.ruleIdentifier;
        this.serviceIdentifier = builder.serviceIdentifier;
    }

    /**
     * <p>
     * Information about the action for the specified listener rule.
     * </p>
     * 
     * @return Information about the action for the specified listener rule.
     */
    public final RuleAction action() {
        return action;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the listener.
     */
    public final String listenerIdentifier() {
        return listenerIdentifier;
    }

    /**
     * <p>
     * The rule match.
     * </p>
     * 
     * @return The rule match.
     */
    public final RuleMatch match() {
        return match;
    }

    /**
     * <p>
     * The rule priority. A listener can't have multiple rules with the same priority.
     * </p>
     * 
     * @return The rule priority. A listener can't have multiple rules with the same priority.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the rule.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the rule.
     */
    public final String ruleIdentifier() {
        return ruleIdentifier;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the service.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the service.
     */
    public final String serviceIdentifier() {
        return serviceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(listenerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(ruleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(serviceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleRequest)) {
            return false;
        }
        UpdateRuleRequest other = (UpdateRuleRequest) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(listenerIdentifier(), other.listenerIdentifier())
                && Objects.equals(match(), other.match()) && Objects.equals(priority(), other.priority())
                && Objects.equals(ruleIdentifier(), other.ruleIdentifier())
                && Objects.equals(serviceIdentifier(), other.serviceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRuleRequest").add("Action", action()).add("ListenerIdentifier", listenerIdentifier())
                .add("Match", match()).add("Priority", priority()).add("RuleIdentifier", ruleIdentifier())
                .add("ServiceIdentifier", serviceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "listenerIdentifier":
            return Optional.ofNullable(clazz.cast(listenerIdentifier()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "ruleIdentifier":
            return Optional.ofNullable(clazz.cast(ruleIdentifier()));
        case "serviceIdentifier":
            return Optional.ofNullable(clazz.cast(serviceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleRequest, T> g) {
        return obj -> g.apply((UpdateRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRuleRequest> {
        /**
         * <p>
         * Information about the action for the specified listener rule.
         * </p>
         * 
         * @param action
         *        Information about the action for the specified listener rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(RuleAction action);

        /**
         * <p>
         * Information about the action for the specified listener rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleAction.Builder} avoiding the need to
         * create one manually via {@link RuleAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleAction.Builder#build()} is called immediately and its result
         * is passed to {@link #action(RuleAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link RuleAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(RuleAction)
         */
        default Builder action(Consumer<RuleAction.Builder> action) {
            return action(RuleAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerIdentifier
         *        The ID or Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerIdentifier(String listenerIdentifier);

        /**
         * <p>
         * The rule match.
         * </p>
         * 
         * @param match
         *        The rule match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(RuleMatch match);

        /**
         * <p>
         * The rule match.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleMatch.Builder} avoiding the need to
         * create one manually via {@link RuleMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleMatch.Builder#build()} is called immediately and its result
         * is passed to {@link #match(RuleMatch)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link RuleMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(RuleMatch)
         */
        default Builder match(Consumer<RuleMatch.Builder> match) {
            return match(RuleMatch.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * The rule priority. A listener can't have multiple rules with the same priority.
         * </p>
         * 
         * @param priority
         *        The rule priority. A listener can't have multiple rules with the same priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the rule.
         * </p>
         * 
         * @param ruleIdentifier
         *        The ID or Amazon Resource Name (ARN) of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleIdentifier(String ruleIdentifier);

        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the service.
         * </p>
         * 
         * @param serviceIdentifier
         *        The ID or Amazon Resource Name (ARN) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIdentifier(String serviceIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private RuleAction action;

        private String listenerIdentifier;

        private RuleMatch match;

        private Integer priority;

        private String ruleIdentifier;

        private String serviceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleRequest model) {
            super(model);
            action(model.action);
            listenerIdentifier(model.listenerIdentifier);
            match(model.match);
            priority(model.priority);
            ruleIdentifier(model.ruleIdentifier);
            serviceIdentifier(model.serviceIdentifier);
        }

        public final RuleAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(RuleAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action = action;
            return this;
        }

        public final String getListenerIdentifier() {
            return listenerIdentifier;
        }

        public final void setListenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
        }

        @Override
        public final Builder listenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
            return this;
        }

        public final RuleMatch.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(RuleMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(RuleMatch match) {
            this.match = match;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getRuleIdentifier() {
            return ruleIdentifier;
        }

        public final void setRuleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
        }

        @Override
        public final Builder ruleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
            return this;
        }

        public final String getServiceIdentifier() {
            return serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleRequest build() {
            return new UpdateRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
