/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a target group. Lambda functions don't support target group configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetGroupConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetGroupConfig.Builder, TargetGroupConfig> {
    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_FIELD = SdkField
            .<HealthCheckConfig> builder(MarshallingType.SDK_POJO).memberName("healthCheck")
            .getter(getter(TargetGroupConfig::healthCheck)).setter(setter(Builder::healthCheck))
            .constructor(HealthCheckConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(TargetGroupConfig::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(TargetGroupConfig::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(TargetGroupConfig::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> PROTOCOL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocolVersion").getter(getter(TargetGroupConfig::protocolVersionAsString))
            .setter(setter(Builder::protocolVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolVersion").build()).build();

    private static final SdkField<String> VPC_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcIdentifier").getter(getter(TargetGroupConfig::vpcIdentifier)).setter(setter(Builder::vpcIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_FIELD,
            IP_ADDRESS_TYPE_FIELD, PORT_FIELD, PROTOCOL_FIELD, PROTOCOL_VERSION_FIELD, VPC_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final HealthCheckConfig healthCheck;

    private final String ipAddressType;

    private final Integer port;

    private final String protocol;

    private final String protocolVersion;

    private final String vpcIdentifier;

    private TargetGroupConfig(BuilderImpl builder) {
        this.healthCheck = builder.healthCheck;
        this.ipAddressType = builder.ipAddressType;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.protocolVersion = builder.protocolVersion;
        this.vpcIdentifier = builder.vpcIdentifier;
    }

    /**
     * <p>
     * The health check configuration.
     * </p>
     * 
     * @return The health check configuration.
     */
    public final HealthCheckConfig healthCheck() {
        return healthCheck;
    }

    /**
     * <p>
     * The type of IP address used for the target group. The possible values are <code>ipv4</code> and <code>ipv6</code>
     * . This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The type of IP address used for the target group. The possible values are <code>ipv4</code> and
     *         <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
     *         <code>ipv4</code>.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The type of IP address used for the target group. The possible values are <code>ipv4</code> and <code>ipv6</code>
     * . This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The type of IP address used for the target group. The possible values are <code>ipv4</code> and
     *         <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
     *         <code>ipv4</code>.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The port on which the targets are listening. For HTTP, the default is <code>80</code>. For HTTPS, the default is
     * <code>443</code>
     * </p>
     * 
     * @return The port on which the targets are listening. For HTTP, the default is <code>80</code>. For HTTPS, the
     *         default is <code>443</code>
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link TargetGroupProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
     * @see TargetGroupProtocol
     */
    public final TargetGroupProtocol protocol() {
        return TargetGroupProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link TargetGroupProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
     * @see TargetGroupProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The protocol version. Default value is <code>HTTP1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolVersion}
     * will return {@link TargetGroupProtocolVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolVersionAsString}.
     * </p>
     * 
     * @return The protocol version. Default value is <code>HTTP1</code>.
     * @see TargetGroupProtocolVersion
     */
    public final TargetGroupProtocolVersion protocolVersion() {
        return TargetGroupProtocolVersion.fromValue(protocolVersion);
    }

    /**
     * <p>
     * The protocol version. Default value is <code>HTTP1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolVersion}
     * will return {@link TargetGroupProtocolVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolVersionAsString}.
     * </p>
     * 
     * @return The protocol version. Default value is <code>HTTP1</code>.
     * @see TargetGroupProtocolVersion
     */
    public final String protocolVersionAsString() {
        return protocolVersion;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcIdentifier() {
        return vpcIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocolVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupConfig)) {
            return false;
        }
        TargetGroupConfig other = (TargetGroupConfig) obj;
        return Objects.equals(healthCheck(), other.healthCheck())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(protocolVersionAsString(), other.protocolVersionAsString())
                && Objects.equals(vpcIdentifier(), other.vpcIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetGroupConfig").add("HealthCheck", healthCheck())
                .add("IpAddressType", ipAddressTypeAsString()).add("Port", port()).add("Protocol", protocolAsString())
                .add("ProtocolVersion", protocolVersionAsString()).add("VpcIdentifier", vpcIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "healthCheck":
            return Optional.ofNullable(clazz.cast(healthCheck()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "protocolVersion":
            return Optional.ofNullable(clazz.cast(protocolVersionAsString()));
        case "vpcIdentifier":
            return Optional.ofNullable(clazz.cast(vpcIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupConfig, T> g) {
        return obj -> g.apply((TargetGroupConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetGroupConfig> {
        /**
         * <p>
         * The health check configuration.
         * </p>
         * 
         * @param healthCheck
         *        The health check configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(HealthCheckConfig healthCheck);

        /**
         * <p>
         * The health check configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the
         * need to create one manually via {@link HealthCheckConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheck(HealthCheckConfig)}.
         * 
         * @param healthCheck
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheck(HealthCheckConfig)
         */
        default Builder healthCheck(Consumer<HealthCheckConfig.Builder> healthCheck) {
            return healthCheck(HealthCheckConfig.builder().applyMutation(healthCheck).build());
        }

        /**
         * <p>
         * The type of IP address used for the target group. The possible values are <code>ipv4</code> and
         * <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
         * <code>ipv4</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The type of IP address used for the target group. The possible values are <code>ipv4</code> and
         *        <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
         *        <code>ipv4</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The type of IP address used for the target group. The possible values are <code>ipv4</code> and
         * <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
         * <code>ipv4</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The type of IP address used for the target group. The possible values are <code>ipv4</code> and
         *        <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to
         *        <code>ipv4</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The port on which the targets are listening. For HTTP, the default is <code>80</code>. For HTTPS, the default
         * is <code>443</code>
         * </p>
         * 
         * @param port
         *        The port on which the targets are listening. For HTTP, the default is <code>80</code>. For HTTPS, the
         *        default is <code>443</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
         * </p>
         * 
         * @param protocol
         *        The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
         * @see TargetGroupProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
         * </p>
         * 
         * @param protocol
         *        The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
         * @see TargetGroupProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupProtocol
         */
        Builder protocol(TargetGroupProtocol protocol);

        /**
         * <p>
         * The protocol version. Default value is <code>HTTP1</code>.
         * </p>
         * 
         * @param protocolVersion
         *        The protocol version. Default value is <code>HTTP1</code>.
         * @see TargetGroupProtocolVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupProtocolVersion
         */
        Builder protocolVersion(String protocolVersion);

        /**
         * <p>
         * The protocol version. Default value is <code>HTTP1</code>.
         * </p>
         * 
         * @param protocolVersion
         *        The protocol version. Default value is <code>HTTP1</code>.
         * @see TargetGroupProtocolVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupProtocolVersion
         */
        Builder protocolVersion(TargetGroupProtocolVersion protocolVersion);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcIdentifier
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIdentifier(String vpcIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private HealthCheckConfig healthCheck;

        private String ipAddressType;

        private Integer port;

        private String protocol;

        private String protocolVersion;

        private String vpcIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupConfig model) {
            healthCheck(model.healthCheck);
            ipAddressType(model.ipAddressType);
            port(model.port);
            protocol(model.protocol);
            protocolVersion(model.protocolVersion);
            vpcIdentifier(model.vpcIdentifier);
        }

        public final HealthCheckConfig.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(HealthCheckConfig.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheckConfig healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TargetGroupProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getProtocolVersion() {
            return protocolVersion;
        }

        public final void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @Override
        public final Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        @Override
        public final Builder protocolVersion(TargetGroupProtocolVersion protocolVersion) {
            this.protocolVersion(protocolVersion == null ? null : protocolVersion.toString());
            return this;
        }

        public final String getVpcIdentifier() {
            return vpcIdentifier;
        }

        public final void setVpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
        }

        @Override
        public final Builder vpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
            return this;
        }

        @Override
        public TargetGroupConfig build() {
            return new TargetGroupConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
