/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse;
import software.amazon.awssdk.services.vpclattice.model.TargetGroupSummary;

public class ListTargetGroupsIterable
implements SdkIterable<ListTargetGroupsResponse> {
    private final VpcLatticeClient client;
    private final ListTargetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTargetGroupsIterable(VpcLatticeClient client, ListTargetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTargetGroupsResponseFetcher();
    }

    public Iterator<ListTargetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TargetGroupSummary> items() {
        Function<ListTargetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTargetGroupsResponseFetcher
    implements SyncPageFetcher<ListTargetGroupsResponse> {
        private ListTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTargetGroupsResponse nextPage(ListTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListTargetGroupsIterable.this.client.listTargetGroups(ListTargetGroupsIterable.this.firstRequest);
            }
            return ListTargetGroupsIterable.this.client.listTargetGroups((ListTargetGroupsRequest)((Object)ListTargetGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

