/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkServiceAssociationSummary;

public class ListServiceNetworkServiceAssociationsPublisher
implements SdkPublisher<ListServiceNetworkServiceAssociationsResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListServiceNetworkServiceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceNetworkServiceAssociationsPublisher(VpcLatticeAsyncClient client, ListServiceNetworkServiceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceNetworkServiceAssociationsPublisher(VpcLatticeAsyncClient client, ListServiceNetworkServiceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceNetworkServiceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceNetworkServiceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceNetworkServiceAssociationSummary> items() {
        Function<ListServiceNetworkServiceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceNetworkServiceAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceNetworkServiceAssociationsResponseFetcher
    implements AsyncPageFetcher<ListServiceNetworkServiceAssociationsResponse> {
        private ListServiceNetworkServiceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceNetworkServiceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceNetworkServiceAssociationsResponse> nextPage(ListServiceNetworkServiceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceNetworkServiceAssociationsPublisher.this.client.listServiceNetworkServiceAssociations(ListServiceNetworkServiceAssociationsPublisher.this.firstRequest);
            }
            return ListServiceNetworkServiceAssociationsPublisher.this.client.listServiceNetworkServiceAssociations((ListServiceNetworkServiceAssociationsRequest)((Object)ListServiceNetworkServiceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

