/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkSummary;

public class ListServiceNetworksIterable
implements SdkIterable<ListServiceNetworksResponse> {
    private final VpcLatticeClient client;
    private final ListServiceNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceNetworksIterable(VpcLatticeClient client, ListServiceNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServiceNetworksResponseFetcher();
    }

    public Iterator<ListServiceNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceNetworkSummary> items() {
        Function<ListServiceNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceNetworksResponseFetcher
    implements SyncPageFetcher<ListServiceNetworksResponse> {
        private ListServiceNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceNetworksResponse nextPage(ListServiceNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListServiceNetworksIterable.this.client.listServiceNetworks(ListServiceNetworksIterable.this.firstRequest);
            }
            return ListServiceNetworksIterable.this.client.listServiceNetworks((ListServiceNetworksRequest)((Object)ListServiceNetworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

