/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFraudstersResponse extends VoiceIdResponse implements
        ToCopyableBuilder<ListFraudstersResponse.Builder, ListFraudstersResponse> {
    private static final SdkField<List<FraudsterSummary>> FRAUDSTER_SUMMARIES_FIELD = SdkField
            .<List<FraudsterSummary>> builder(MarshallingType.LIST)
            .memberName("FraudsterSummaries")
            .getter(getter(ListFraudstersResponse::fraudsterSummaries))
            .setter(setter(Builder::fraudsterSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FraudsterSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FraudsterSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FraudsterSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFraudstersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAUDSTER_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FraudsterSummary> fraudsterSummaries;

    private final String nextToken;

    private ListFraudstersResponse(BuilderImpl builder) {
        super(builder);
        this.fraudsterSummaries = builder.fraudsterSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FraudsterSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFraudsterSummaries() {
        return fraudsterSummaries != null && !(fraudsterSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains details about each fraudster in the Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFraudsterSummaries} method.
     * </p>
     * 
     * @return A list that contains details about each fraudster in the Amazon Web Services account.
     */
    public final List<FraudsterSummary> fraudsterSummaries() {
        return fraudsterSummaries;
    }

    /**
     * <p>
     * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours.
     * </p>
     * 
     * @return If <code>NextToken</code> is returned, there are more results available. The value of
     *         <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFraudsterSummaries() ? fraudsterSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFraudstersResponse)) {
            return false;
        }
        ListFraudstersResponse other = (ListFraudstersResponse) obj;
        return hasFraudsterSummaries() == other.hasFraudsterSummaries()
                && Objects.equals(fraudsterSummaries(), other.fraudsterSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFraudstersResponse")
                .add("FraudsterSummaries", hasFraudsterSummaries() ? fraudsterSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FraudsterSummaries":
            return Optional.ofNullable(clazz.cast(fraudsterSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FraudsterSummaries", FRAUDSTER_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFraudstersResponse, T> g) {
        return obj -> g.apply((ListFraudstersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VoiceIdResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFraudstersResponse> {
        /**
         * <p>
         * A list that contains details about each fraudster in the Amazon Web Services account.
         * </p>
         * 
         * @param fraudsterSummaries
         *        A list that contains details about each fraudster in the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fraudsterSummaries(Collection<FraudsterSummary> fraudsterSummaries);

        /**
         * <p>
         * A list that contains details about each fraudster in the Amazon Web Services account.
         * </p>
         * 
         * @param fraudsterSummaries
         *        A list that contains details about each fraudster in the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fraudsterSummaries(FraudsterSummary... fraudsterSummaries);

        /**
         * <p>
         * A list that contains details about each fraudster in the Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.voiceid.model.FraudsterSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.voiceid.model.FraudsterSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.voiceid.model.FraudsterSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #fraudsterSummaries(List<FraudsterSummary>)}.
         * 
         * @param fraudsterSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.voiceid.model.FraudsterSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fraudsterSummaries(java.util.Collection<FraudsterSummary>)
         */
        Builder fraudsterSummaries(Consumer<FraudsterSummary.Builder>... fraudsterSummaries);

        /**
         * <p>
         * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is returned, there are more results available. The value of
         *        <code>NextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends VoiceIdResponse.BuilderImpl implements Builder {
        private List<FraudsterSummary> fraudsterSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFraudstersResponse model) {
            super(model);
            fraudsterSummaries(model.fraudsterSummaries);
            nextToken(model.nextToken);
        }

        public final List<FraudsterSummary.Builder> getFraudsterSummaries() {
            List<FraudsterSummary.Builder> result = FraudsterSummariesCopier.copyToBuilder(this.fraudsterSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFraudsterSummaries(Collection<FraudsterSummary.BuilderImpl> fraudsterSummaries) {
            this.fraudsterSummaries = FraudsterSummariesCopier.copyFromBuilder(fraudsterSummaries);
        }

        @Override
        public final Builder fraudsterSummaries(Collection<FraudsterSummary> fraudsterSummaries) {
            this.fraudsterSummaries = FraudsterSummariesCopier.copy(fraudsterSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fraudsterSummaries(FraudsterSummary... fraudsterSummaries) {
            fraudsterSummaries(Arrays.asList(fraudsterSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fraudsterSummaries(Consumer<FraudsterSummary.Builder>... fraudsterSummaries) {
            fraudsterSummaries(Stream.of(fraudsterSummaries).map(c -> FraudsterSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFraudstersResponse build() {
            return new ListFraudstersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
