/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations defining enrollment behavior for the batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnrollmentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EnrollmentConfig.Builder, EnrollmentConfig> {
    private static final SdkField<String> EXISTING_ENROLLMENT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExistingEnrollmentAction").getter(getter(EnrollmentConfig::existingEnrollmentActionAsString))
            .setter(setter(Builder::existingEnrollmentAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingEnrollmentAction").build())
            .build();

    private static final SdkField<EnrollmentJobFraudDetectionConfig> FRAUD_DETECTION_CONFIG_FIELD = SdkField
            .<EnrollmentJobFraudDetectionConfig> builder(MarshallingType.SDK_POJO).memberName("FraudDetectionConfig")
            .getter(getter(EnrollmentConfig::fraudDetectionConfig)).setter(setter(Builder::fraudDetectionConfig))
            .constructor(EnrollmentJobFraudDetectionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FraudDetectionConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXISTING_ENROLLMENT_ACTION_FIELD, FRAUD_DETECTION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String existingEnrollmentAction;

    private final EnrollmentJobFraudDetectionConfig fraudDetectionConfig;

    private EnrollmentConfig(BuilderImpl builder) {
        this.existingEnrollmentAction = builder.existingEnrollmentAction;
        this.fraudDetectionConfig = builder.fraudDetectionConfig;
    }

    /**
     * <p>
     * The action to take when the specified speaker is already enrolled in the specified domain. The default value is
     * <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
     * <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker with new
     * data generated from the latest audio.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #existingEnrollmentAction} will return {@link ExistingEnrollmentAction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #existingEnrollmentActionAsString}.
     * </p>
     * 
     * @return The action to take when the specified speaker is already enrolled in the specified domain. The default
     *         value is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
     *         <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker
     *         with new data generated from the latest audio.
     * @see ExistingEnrollmentAction
     */
    public final ExistingEnrollmentAction existingEnrollmentAction() {
        return ExistingEnrollmentAction.fromValue(existingEnrollmentAction);
    }

    /**
     * <p>
     * The action to take when the specified speaker is already enrolled in the specified domain. The default value is
     * <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
     * <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker with new
     * data generated from the latest audio.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #existingEnrollmentAction} will return {@link ExistingEnrollmentAction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #existingEnrollmentActionAsString}.
     * </p>
     * 
     * @return The action to take when the specified speaker is already enrolled in the specified domain. The default
     *         value is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
     *         <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker
     *         with new data generated from the latest audio.
     * @see ExistingEnrollmentAction
     */
    public final String existingEnrollmentActionAsString() {
        return existingEnrollmentAction;
    }

    /**
     * <p>
     * The fraud detection configuration to use for the speaker enrollment job.
     * </p>
     * 
     * @return The fraud detection configuration to use for the speaker enrollment job.
     */
    public final EnrollmentJobFraudDetectionConfig fraudDetectionConfig() {
        return fraudDetectionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(existingEnrollmentActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fraudDetectionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnrollmentConfig)) {
            return false;
        }
        EnrollmentConfig other = (EnrollmentConfig) obj;
        return Objects.equals(existingEnrollmentActionAsString(), other.existingEnrollmentActionAsString())
                && Objects.equals(fraudDetectionConfig(), other.fraudDetectionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnrollmentConfig").add("ExistingEnrollmentAction", existingEnrollmentActionAsString())
                .add("FraudDetectionConfig", fraudDetectionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExistingEnrollmentAction":
            return Optional.ofNullable(clazz.cast(existingEnrollmentActionAsString()));
        case "FraudDetectionConfig":
            return Optional.ofNullable(clazz.cast(fraudDetectionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExistingEnrollmentAction", EXISTING_ENROLLMENT_ACTION_FIELD);
        map.put("FraudDetectionConfig", FRAUD_DETECTION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnrollmentConfig, T> g) {
        return obj -> g.apply((EnrollmentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnrollmentConfig> {
        /**
         * <p>
         * The action to take when the specified speaker is already enrolled in the specified domain. The default value
         * is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
         * <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker with
         * new data generated from the latest audio.
         * </p>
         * 
         * @param existingEnrollmentAction
         *        The action to take when the specified speaker is already enrolled in the specified domain. The default
         *        value is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
         *        <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker
         *        with new data generated from the latest audio.
         * @see ExistingEnrollmentAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExistingEnrollmentAction
         */
        Builder existingEnrollmentAction(String existingEnrollmentAction);

        /**
         * <p>
         * The action to take when the specified speaker is already enrolled in the specified domain. The default value
         * is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
         * <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker with
         * new data generated from the latest audio.
         * </p>
         * 
         * @param existingEnrollmentAction
         *        The action to take when the specified speaker is already enrolled in the specified domain. The default
         *        value is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
         *        <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker
         *        with new data generated from the latest audio.
         * @see ExistingEnrollmentAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExistingEnrollmentAction
         */
        Builder existingEnrollmentAction(ExistingEnrollmentAction existingEnrollmentAction);

        /**
         * <p>
         * The fraud detection configuration to use for the speaker enrollment job.
         * </p>
         * 
         * @param fraudDetectionConfig
         *        The fraud detection configuration to use for the speaker enrollment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fraudDetectionConfig(EnrollmentJobFraudDetectionConfig fraudDetectionConfig);

        /**
         * <p>
         * The fraud detection configuration to use for the speaker enrollment job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EnrollmentJobFraudDetectionConfig.Builder} avoiding the need to create one manually via
         * {@link EnrollmentJobFraudDetectionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnrollmentJobFraudDetectionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #fraudDetectionConfig(EnrollmentJobFraudDetectionConfig)}.
         * 
         * @param fraudDetectionConfig
         *        a consumer that will call methods on {@link EnrollmentJobFraudDetectionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fraudDetectionConfig(EnrollmentJobFraudDetectionConfig)
         */
        default Builder fraudDetectionConfig(Consumer<EnrollmentJobFraudDetectionConfig.Builder> fraudDetectionConfig) {
            return fraudDetectionConfig(EnrollmentJobFraudDetectionConfig.builder().applyMutation(fraudDetectionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String existingEnrollmentAction;

        private EnrollmentJobFraudDetectionConfig fraudDetectionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EnrollmentConfig model) {
            existingEnrollmentAction(model.existingEnrollmentAction);
            fraudDetectionConfig(model.fraudDetectionConfig);
        }

        public final String getExistingEnrollmentAction() {
            return existingEnrollmentAction;
        }

        public final void setExistingEnrollmentAction(String existingEnrollmentAction) {
            this.existingEnrollmentAction = existingEnrollmentAction;
        }

        @Override
        public final Builder existingEnrollmentAction(String existingEnrollmentAction) {
            this.existingEnrollmentAction = existingEnrollmentAction;
            return this;
        }

        @Override
        public final Builder existingEnrollmentAction(ExistingEnrollmentAction existingEnrollmentAction) {
            this.existingEnrollmentAction(existingEnrollmentAction == null ? null : existingEnrollmentAction.toString());
            return this;
        }

        public final EnrollmentJobFraudDetectionConfig.Builder getFraudDetectionConfig() {
            return fraudDetectionConfig != null ? fraudDetectionConfig.toBuilder() : null;
        }

        public final void setFraudDetectionConfig(EnrollmentJobFraudDetectionConfig.BuilderImpl fraudDetectionConfig) {
            this.fraudDetectionConfig = fraudDetectionConfig != null ? fraudDetectionConfig.build() : null;
        }

        @Override
        public final Builder fraudDetectionConfig(EnrollmentJobFraudDetectionConfig fraudDetectionConfig) {
            this.fraudDetectionConfig = fraudDetectionConfig;
            return this;
        }

        @Override
        public EnrollmentConfig build() {
            return new EnrollmentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
