/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.VoiceIdRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWatchlistRequest
extends VoiceIdRequest
implements ToCopyableBuilder<Builder, UpdateWatchlistRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateWatchlistRequest.getter(UpdateWatchlistRequest::description)).setter(UpdateWatchlistRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(UpdateWatchlistRequest.getter(UpdateWatchlistRequest::domainId)).setter(UpdateWatchlistRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateWatchlistRequest.getter(UpdateWatchlistRequest::name)).setter(UpdateWatchlistRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> WATCHLIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WatchlistId").getter(UpdateWatchlistRequest.getter(UpdateWatchlistRequest::watchlistId)).setter(UpdateWatchlistRequest.setter(Builder::watchlistId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WatchlistId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_ID_FIELD, NAME_FIELD, WATCHLIST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWatchlistRequest.memberNameToFieldInitializer();
    private final String description;
    private final String domainId;
    private final String name;
    private final String watchlistId;

    private UpdateWatchlistRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.name = builder.name;
        this.watchlistId = builder.watchlistId;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String name() {
        return this.name;
    }

    public final String watchlistId() {
        return this.watchlistId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.watchlistId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWatchlistRequest)) {
            return false;
        }
        UpdateWatchlistRequest other = (UpdateWatchlistRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.watchlistId(), other.watchlistId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWatchlistRequest").add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("WatchlistId", (Object)this.watchlistId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "WatchlistId": {
                return Optional.ofNullable(clazz.cast(this.watchlistId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("WatchlistId", WATCHLIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWatchlistRequest, T> g) {
        return obj -> g.apply((UpdateWatchlistRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdRequest.BuilderImpl
    implements Builder {
        private String description;
        private String domainId;
        private String name;
        private String watchlistId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWatchlistRequest model) {
            super(model);
            this.description(model.description);
            this.domainId(model.domainId);
            this.name(model.name);
            this.watchlistId(model.watchlistId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWatchlistId() {
            return this.watchlistId;
        }

        public final void setWatchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
        }

        @Override
        public final Builder watchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWatchlistRequest build() {
            return new UpdateWatchlistRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VoiceIdRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWatchlistRequest> {
        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder name(String var1);

        public Builder watchlistId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

