/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.voiceid.model.VoiceIdResponse;
import software.amazon.awssdk.services.voiceid.model.WatchlistSummariesCopier;
import software.amazon.awssdk.services.voiceid.model.WatchlistSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWatchlistsResponse
extends VoiceIdResponse
implements ToCopyableBuilder<Builder, ListWatchlistsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWatchlistsResponse.getter(ListWatchlistsResponse::nextToken)).setter(ListWatchlistsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<WatchlistSummary>> WATCHLIST_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WatchlistSummaries").getter(ListWatchlistsResponse.getter(ListWatchlistsResponse::watchlistSummaries)).setter(ListWatchlistsResponse.setter(Builder::watchlistSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WatchlistSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WatchlistSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WATCHLIST_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWatchlistsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<WatchlistSummary> watchlistSummaries;

    private ListWatchlistsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.watchlistSummaries = builder.watchlistSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWatchlistSummaries() {
        return this.watchlistSummaries != null && !(this.watchlistSummaries instanceof SdkAutoConstructList);
    }

    public final List<WatchlistSummary> watchlistSummaries() {
        return this.watchlistSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWatchlistSummaries() ? this.watchlistSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWatchlistsResponse)) {
            return false;
        }
        ListWatchlistsResponse other = (ListWatchlistsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWatchlistSummaries() == other.hasWatchlistSummaries() && Objects.equals(this.watchlistSummaries(), other.watchlistSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListWatchlistsResponse").add("NextToken", (Object)this.nextToken()).add("WatchlistSummaries", this.hasWatchlistSummaries() ? this.watchlistSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "WatchlistSummaries": {
                return Optional.ofNullable(clazz.cast(this.watchlistSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WatchlistSummaries", WATCHLIST_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWatchlistsResponse, T> g) {
        return obj -> g.apply((ListWatchlistsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WatchlistSummary> watchlistSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWatchlistsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.watchlistSummaries(model.watchlistSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WatchlistSummary.Builder> getWatchlistSummaries() {
            List<WatchlistSummary.Builder> result = WatchlistSummariesCopier.copyToBuilder(this.watchlistSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatchlistSummaries(Collection<WatchlistSummary.BuilderImpl> watchlistSummaries) {
            this.watchlistSummaries = WatchlistSummariesCopier.copyFromBuilder(watchlistSummaries);
        }

        @Override
        public final Builder watchlistSummaries(Collection<WatchlistSummary> watchlistSummaries) {
            this.watchlistSummaries = WatchlistSummariesCopier.copy(watchlistSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchlistSummaries(WatchlistSummary ... watchlistSummaries) {
            this.watchlistSummaries(Arrays.asList(watchlistSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchlistSummaries(Consumer<WatchlistSummary.Builder> ... watchlistSummaries) {
            this.watchlistSummaries(Stream.of(watchlistSummaries).map(c -> (WatchlistSummary)((WatchlistSummary.Builder)WatchlistSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWatchlistsResponse build() {
            return new ListWatchlistsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VoiceIdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWatchlistsResponse> {
        public Builder nextToken(String var1);

        public Builder watchlistSummaries(Collection<WatchlistSummary> var1);

        public Builder watchlistSummaries(WatchlistSummary ... var1);

        public Builder watchlistSummaries(Consumer<WatchlistSummary.Builder> ... var1);
    }
}

