/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.voiceid.VoiceIdClient;
import software.amazon.awssdk.services.voiceid.VoiceIdServiceClientConfiguration;
import software.amazon.awssdk.services.voiceid.internal.VoiceIdServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.voiceid.model.AccessDeniedException;
import software.amazon.awssdk.services.voiceid.model.AssociateFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.AssociateFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.ConflictException;
import software.amazon.awssdk.services.voiceid.model.CreateDomainRequest;
import software.amazon.awssdk.services.voiceid.model.CreateDomainResponse;
import software.amazon.awssdk.services.voiceid.model.CreateWatchlistRequest;
import software.amazon.awssdk.services.voiceid.model.CreateWatchlistResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteDomainRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteDomainResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteSpeakerRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteSpeakerResponse;
import software.amazon.awssdk.services.voiceid.model.DeleteWatchlistRequest;
import software.amazon.awssdk.services.voiceid.model.DeleteWatchlistResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeDomainRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeDomainResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRegistrationJobRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRegistrationJobResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerEnrollmentJobRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerEnrollmentJobResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeSpeakerResponse;
import software.amazon.awssdk.services.voiceid.model.DescribeWatchlistRequest;
import software.amazon.awssdk.services.voiceid.model.DescribeWatchlistResponse;
import software.amazon.awssdk.services.voiceid.model.DisassociateFraudsterRequest;
import software.amazon.awssdk.services.voiceid.model.DisassociateFraudsterResponse;
import software.amazon.awssdk.services.voiceid.model.EvaluateSessionRequest;
import software.amazon.awssdk.services.voiceid.model.EvaluateSessionResponse;
import software.amazon.awssdk.services.voiceid.model.InternalServerException;
import software.amazon.awssdk.services.voiceid.model.ListDomainsRequest;
import software.amazon.awssdk.services.voiceid.model.ListDomainsResponse;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListFraudsterRegistrationJobsResponse;
import software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest;
import software.amazon.awssdk.services.voiceid.model.ListFraudstersResponse;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse;
import software.amazon.awssdk.services.voiceid.model.ListSpeakersRequest;
import software.amazon.awssdk.services.voiceid.model.ListSpeakersResponse;
import software.amazon.awssdk.services.voiceid.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.voiceid.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest;
import software.amazon.awssdk.services.voiceid.model.ListWatchlistsResponse;
import software.amazon.awssdk.services.voiceid.model.OptOutSpeakerRequest;
import software.amazon.awssdk.services.voiceid.model.OptOutSpeakerResponse;
import software.amazon.awssdk.services.voiceid.model.ResourceNotFoundException;
import software.amazon.awssdk.services.voiceid.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.voiceid.model.StartFraudsterRegistrationJobRequest;
import software.amazon.awssdk.services.voiceid.model.StartFraudsterRegistrationJobResponse;
import software.amazon.awssdk.services.voiceid.model.StartSpeakerEnrollmentJobRequest;
import software.amazon.awssdk.services.voiceid.model.StartSpeakerEnrollmentJobResponse;
import software.amazon.awssdk.services.voiceid.model.TagResourceRequest;
import software.amazon.awssdk.services.voiceid.model.TagResourceResponse;
import software.amazon.awssdk.services.voiceid.model.ThrottlingException;
import software.amazon.awssdk.services.voiceid.model.UntagResourceRequest;
import software.amazon.awssdk.services.voiceid.model.UntagResourceResponse;
import software.amazon.awssdk.services.voiceid.model.UpdateDomainRequest;
import software.amazon.awssdk.services.voiceid.model.UpdateDomainResponse;
import software.amazon.awssdk.services.voiceid.model.UpdateWatchlistRequest;
import software.amazon.awssdk.services.voiceid.model.UpdateWatchlistResponse;
import software.amazon.awssdk.services.voiceid.model.ValidationException;
import software.amazon.awssdk.services.voiceid.model.VoiceIdException;
import software.amazon.awssdk.services.voiceid.transform.AssociateFraudsterRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.CreateWatchlistRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DeleteFraudsterRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DeleteSpeakerRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DeleteWatchlistRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DescribeFraudsterRegistrationJobRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DescribeFraudsterRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DescribeSpeakerEnrollmentJobRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DescribeSpeakerRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DescribeWatchlistRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.DisassociateFraudsterRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.EvaluateSessionRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.ListFraudsterRegistrationJobsRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.ListFraudstersRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.ListSpeakerEnrollmentJobsRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.ListSpeakersRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.ListWatchlistsRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.OptOutSpeakerRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.StartFraudsterRegistrationJobRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.StartSpeakerEnrollmentJobRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.UpdateDomainRequestMarshaller;
import software.amazon.awssdk.services.voiceid.transform.UpdateWatchlistRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultVoiceIdClient
implements VoiceIdClient {
    private static final Logger log = Logger.loggerFor(DefaultVoiceIdClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultVoiceIdClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateFraudsterResponse associateFraudster(AssociateFraudsterRequest associateFraudsterRequest) throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateFraudsterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateFraudsterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, associateFraudsterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateFraudster");
            AssociateFraudsterResponse associateFraudsterResponse = (AssociateFraudsterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateFraudster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateFraudsterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateFraudsterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateFraudsterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$associateFraudster$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, createDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomain");
            CreateDomainResponse createDomainResponse = (CreateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$createDomain$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWatchlistResponse createWatchlist(CreateWatchlistRequest createWatchlistRequest) throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWatchlistResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createWatchlistRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, createWatchlistRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWatchlist");
            CreateWatchlistResponse createWatchlistResponse = (CreateWatchlistResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWatchlist").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createWatchlistRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWatchlistRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWatchlistResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$createWatchlist$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, deleteDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomain");
            DeleteDomainResponse deleteDomainResponse = (DeleteDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$deleteDomain$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFraudsterResponse deleteFraudster(DeleteFraudsterRequest deleteFraudsterRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFraudsterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFraudsterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, deleteFraudsterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFraudster");
            DeleteFraudsterResponse deleteFraudsterResponse = (DeleteFraudsterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFraudster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFraudsterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFraudsterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFraudsterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$deleteFraudster$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSpeakerResponse deleteSpeaker(DeleteSpeakerRequest deleteSpeakerRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSpeakerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSpeakerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, deleteSpeakerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSpeaker");
            DeleteSpeakerResponse deleteSpeakerResponse = (DeleteSpeakerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSpeaker").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSpeakerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSpeakerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSpeakerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$deleteSpeaker$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWatchlistResponse deleteWatchlist(DeleteWatchlistRequest deleteWatchlistRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWatchlistResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWatchlistRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, deleteWatchlistRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWatchlist");
            DeleteWatchlistResponse deleteWatchlistResponse = (DeleteWatchlistResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWatchlist").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteWatchlistRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWatchlistRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWatchlistResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$deleteWatchlist$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, describeDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomain");
            DescribeDomainResponse describeDomainResponse = (DescribeDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$describeDomain$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFraudsterResponse describeFraudster(DescribeFraudsterRequest describeFraudsterRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFraudsterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFraudsterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, describeFraudsterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFraudster");
            DescribeFraudsterResponse describeFraudsterResponse = (DescribeFraudsterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFraudster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFraudsterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFraudsterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFraudsterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$describeFraudster$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFraudsterRegistrationJobResponse describeFraudsterRegistrationJob(DescribeFraudsterRegistrationJobRequest describeFraudsterRegistrationJobRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFraudsterRegistrationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFraudsterRegistrationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, describeFraudsterRegistrationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFraudsterRegistrationJob");
            DescribeFraudsterRegistrationJobResponse describeFraudsterRegistrationJobResponse = (DescribeFraudsterRegistrationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFraudsterRegistrationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFraudsterRegistrationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFraudsterRegistrationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFraudsterRegistrationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$describeFraudsterRegistrationJob$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSpeakerResponse describeSpeaker(DescribeSpeakerRequest describeSpeakerRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSpeakerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSpeakerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, describeSpeakerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSpeaker");
            DescribeSpeakerResponse describeSpeakerResponse = (DescribeSpeakerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSpeaker").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSpeakerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSpeakerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSpeakerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$describeSpeaker$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSpeakerEnrollmentJobResponse describeSpeakerEnrollmentJob(DescribeSpeakerEnrollmentJobRequest describeSpeakerEnrollmentJobRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSpeakerEnrollmentJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSpeakerEnrollmentJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, describeSpeakerEnrollmentJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSpeakerEnrollmentJob");
            DescribeSpeakerEnrollmentJobResponse describeSpeakerEnrollmentJobResponse = (DescribeSpeakerEnrollmentJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSpeakerEnrollmentJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSpeakerEnrollmentJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSpeakerEnrollmentJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSpeakerEnrollmentJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$describeSpeakerEnrollmentJob$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWatchlistResponse describeWatchlist(DescribeWatchlistRequest describeWatchlistRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWatchlistResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeWatchlistRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, describeWatchlistRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWatchlist");
            DescribeWatchlistResponse describeWatchlistResponse = (DescribeWatchlistResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWatchlist").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeWatchlistRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWatchlistRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWatchlistResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$describeWatchlist$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateFraudsterResponse disassociateFraudster(DisassociateFraudsterRequest disassociateFraudsterRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateFraudsterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateFraudsterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, disassociateFraudsterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateFraudster");
            DisassociateFraudsterResponse disassociateFraudsterResponse = (DisassociateFraudsterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateFraudster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateFraudsterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateFraudsterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateFraudsterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$disassociateFraudster$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluateSessionResponse evaluateSession(EvaluateSessionRequest evaluateSessionRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EvaluateSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)evaluateSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, evaluateSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EvaluateSession");
            EvaluateSessionResponse evaluateSessionResponse = (EvaluateSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EvaluateSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)evaluateSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EvaluateSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return evaluateSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$evaluateSession$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, listDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomains");
            ListDomainsResponse listDomainsResponse = (ListDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomains").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$listDomains$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFraudsterRegistrationJobsResponse listFraudsterRegistrationJobs(ListFraudsterRegistrationJobsRequest listFraudsterRegistrationJobsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFraudsterRegistrationJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFraudsterRegistrationJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, listFraudsterRegistrationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFraudsterRegistrationJobs");
            ListFraudsterRegistrationJobsResponse listFraudsterRegistrationJobsResponse = (ListFraudsterRegistrationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFraudsterRegistrationJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFraudsterRegistrationJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFraudsterRegistrationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFraudsterRegistrationJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$listFraudsterRegistrationJobs$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFraudstersResponse listFraudsters(ListFraudstersRequest listFraudstersRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFraudstersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFraudstersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, listFraudstersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFraudsters");
            ListFraudstersResponse listFraudstersResponse = (ListFraudstersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFraudsters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFraudstersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFraudstersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFraudstersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$listFraudsters$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSpeakerEnrollmentJobsResponse listSpeakerEnrollmentJobs(ListSpeakerEnrollmentJobsRequest listSpeakerEnrollmentJobsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSpeakerEnrollmentJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSpeakerEnrollmentJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, listSpeakerEnrollmentJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSpeakerEnrollmentJobs");
            ListSpeakerEnrollmentJobsResponse listSpeakerEnrollmentJobsResponse = (ListSpeakerEnrollmentJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSpeakerEnrollmentJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSpeakerEnrollmentJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSpeakerEnrollmentJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSpeakerEnrollmentJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$listSpeakerEnrollmentJobs$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSpeakersResponse listSpeakers(ListSpeakersRequest listSpeakersRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSpeakersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSpeakersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, listSpeakersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSpeakers");
            ListSpeakersResponse listSpeakersResponse = (ListSpeakersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSpeakers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSpeakersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSpeakersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSpeakersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$listSpeakers$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$listTagsForResource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWatchlistsResponse listWatchlists(ListWatchlistsRequest listWatchlistsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWatchlistsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWatchlistsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, listWatchlistsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWatchlists");
            ListWatchlistsResponse listWatchlistsResponse = (ListWatchlistsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWatchlists").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listWatchlistsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWatchlistsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWatchlistsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$listWatchlists$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptOutSpeakerResponse optOutSpeaker(OptOutSpeakerRequest optOutSpeakerRequest) throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, OptOutSpeakerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)optOutSpeakerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, optOutSpeakerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"OptOutSpeaker");
            OptOutSpeakerResponse optOutSpeakerResponse = (OptOutSpeakerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("OptOutSpeaker").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)optOutSpeakerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new OptOutSpeakerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return optOutSpeakerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$optOutSpeaker$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartFraudsterRegistrationJobResponse startFraudsterRegistrationJob(StartFraudsterRegistrationJobRequest startFraudsterRegistrationJobRequest) throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFraudsterRegistrationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startFraudsterRegistrationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, startFraudsterRegistrationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFraudsterRegistrationJob");
            StartFraudsterRegistrationJobResponse startFraudsterRegistrationJobResponse = (StartFraudsterRegistrationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFraudsterRegistrationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startFraudsterRegistrationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartFraudsterRegistrationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startFraudsterRegistrationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$startFraudsterRegistrationJob$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSpeakerEnrollmentJobResponse startSpeakerEnrollmentJob(StartSpeakerEnrollmentJobRequest startSpeakerEnrollmentJobRequest) throws ServiceQuotaExceededException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSpeakerEnrollmentJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSpeakerEnrollmentJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, startSpeakerEnrollmentJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSpeakerEnrollmentJob");
            StartSpeakerEnrollmentJobResponse startSpeakerEnrollmentJobResponse = (StartSpeakerEnrollmentJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSpeakerEnrollmentJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSpeakerEnrollmentJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSpeakerEnrollmentJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSpeakerEnrollmentJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$startSpeakerEnrollmentJob$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$tagResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$untagResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainResponse updateDomain(UpdateDomainRequest updateDomainRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, updateDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomain");
            UpdateDomainResponse updateDomainResponse = (UpdateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$updateDomain$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWatchlistResponse updateWatchlist(UpdateWatchlistRequest updateWatchlistRequest) throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, VoiceIdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWatchlistResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateWatchlistRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultVoiceIdClient.resolveMetricPublishers(clientConfiguration, updateWatchlistRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Voice ID");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWatchlist");
            UpdateWatchlistResponse updateWatchlistResponse = (UpdateWatchlistResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWatchlist").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateWatchlistRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWatchlistRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWatchlistResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVoiceIdClient.lambda$updateWatchlist$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "voiceid";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        VoiceIdServiceClientConfigurationBuilder serviceConfigBuilder = new VoiceIdServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(VoiceIdException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final VoiceIdServiceClientConfiguration serviceClientConfiguration() {
        return new VoiceIdServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateWatchlist$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomain$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSpeakerEnrollmentJob$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFraudsterRegistrationJob$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$optOutSpeaker$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWatchlists$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSpeakers$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSpeakerEnrollmentJobs$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFraudsters$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFraudsterRegistrationJobs$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomains$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$evaluateSession$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateFraudster$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWatchlist$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSpeakerEnrollmentJob$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSpeaker$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFraudsterRegistrationJob$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFraudster$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomain$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWatchlist$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSpeaker$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFraudster$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomain$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWatchlist$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomain$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateFraudster$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

