/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.voiceid.VoiceIdAsyncClient;
import software.amazon.awssdk.services.voiceid.model.FraudsterSummary;
import software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest;
import software.amazon.awssdk.services.voiceid.model.ListFraudstersResponse;

public class ListFraudstersPublisher
implements SdkPublisher<ListFraudstersResponse> {
    private final VoiceIdAsyncClient client;
    private final ListFraudstersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFraudstersPublisher(VoiceIdAsyncClient client, ListFraudstersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFraudstersPublisher(VoiceIdAsyncClient client, ListFraudstersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFraudstersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFraudstersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FraudsterSummary> fraudsterSummaries() {
        Function<ListFraudstersResponse, Iterator> getIterator = response -> {
            if (response != null && response.fraudsterSummaries() != null) {
                return response.fraudsterSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFraudstersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFraudstersResponseFetcher
    implements AsyncPageFetcher<ListFraudstersResponse> {
        private ListFraudstersResponseFetcher() {
        }

        public boolean hasNextPage(ListFraudstersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFraudstersResponse> nextPage(ListFraudstersResponse previousPage) {
            if (previousPage == null) {
                return ListFraudstersPublisher.this.client.listFraudsters(ListFraudstersPublisher.this.firstRequest);
            }
            return ListFraudstersPublisher.this.client.listFraudsters((ListFraudstersRequest)((Object)ListFraudstersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

