/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.EnrollmentConfig;
import software.amazon.awssdk.services.voiceid.model.FailureDetails;
import software.amazon.awssdk.services.voiceid.model.InputDataConfig;
import software.amazon.awssdk.services.voiceid.model.JobProgress;
import software.amazon.awssdk.services.voiceid.model.OutputDataConfig;
import software.amazon.awssdk.services.voiceid.model.SpeakerEnrollmentJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpeakerEnrollmentJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpeakerEnrollmentJob> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::createdAt)).setter(SpeakerEnrollmentJob.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::dataAccessRoleArn)).setter(SpeakerEnrollmentJob.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::domainId)).setter(SpeakerEnrollmentJob.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedAt").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::endedAt)).setter(SpeakerEnrollmentJob.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build()}).build();
    private static final SdkField<EnrollmentConfig> ENROLLMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnrollmentConfig").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::enrollmentConfig)).setter(SpeakerEnrollmentJob.setter(Builder::enrollmentConfig)).constructor(EnrollmentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentConfig").build()}).build();
    private static final SdkField<FailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::failureDetails)).setter(SpeakerEnrollmentJob.setter(Builder::failureDetails)).constructor(FailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::inputDataConfig)).setter(SpeakerEnrollmentJob.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::jobId)).setter(SpeakerEnrollmentJob.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::jobName)).setter(SpeakerEnrollmentJob.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<JobProgress> JOB_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobProgress").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::jobProgress)).setter(SpeakerEnrollmentJob.setter(Builder::jobProgress)).constructor(JobProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobProgress").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::jobStatusAsString)).setter(SpeakerEnrollmentJob.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(SpeakerEnrollmentJob.getter(SpeakerEnrollmentJob::outputDataConfig)).setter(SpeakerEnrollmentJob.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, DOMAIN_ID_FIELD, ENDED_AT_FIELD, ENROLLMENT_CONFIG_FIELD, FAILURE_DETAILS_FIELD, INPUT_DATA_CONFIG_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, JOB_PROGRESS_FIELD, JOB_STATUS_FIELD, OUTPUT_DATA_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String dataAccessRoleArn;
    private final String domainId;
    private final Instant endedAt;
    private final EnrollmentConfig enrollmentConfig;
    private final FailureDetails failureDetails;
    private final InputDataConfig inputDataConfig;
    private final String jobId;
    private final String jobName;
    private final JobProgress jobProgress;
    private final String jobStatus;
    private final OutputDataConfig outputDataConfig;

    private SpeakerEnrollmentJob(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.domainId = builder.domainId;
        this.endedAt = builder.endedAt;
        this.enrollmentConfig = builder.enrollmentConfig;
        this.failureDetails = builder.failureDetails;
        this.inputDataConfig = builder.inputDataConfig;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobProgress = builder.jobProgress;
        this.jobStatus = builder.jobStatus;
        this.outputDataConfig = builder.outputDataConfig;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final EnrollmentConfig enrollmentConfig() {
        return this.enrollmentConfig;
    }

    public final FailureDetails failureDetails() {
        return this.failureDetails;
    }

    public final InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobProgress jobProgress() {
        return this.jobProgress;
    }

    public final SpeakerEnrollmentJobStatus jobStatus() {
        return SpeakerEnrollmentJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrollmentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeakerEnrollmentJob)) {
            return false;
        }
        SpeakerEnrollmentJob other = (SpeakerEnrollmentJob)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.enrollmentConfig(), other.enrollmentConfig()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobProgress(), other.jobProgress()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig());
    }

    public final String toString() {
        return ToString.builder((String)"SpeakerEnrollmentJob").add("CreatedAt", (Object)this.createdAt()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("DomainId", (Object)this.domainId()).add("EndedAt", (Object)this.endedAt()).add("EnrollmentConfig", (Object)this.enrollmentConfig()).add("FailureDetails", (Object)this.failureDetails()).add("InputDataConfig", (Object)this.inputDataConfig()).add("JobId", (Object)this.jobId()).add("JobName", (Object)(this.jobName() == null ? null : "*** Sensitive Data Redacted ***")).add("JobProgress", (Object)this.jobProgress()).add("JobStatus", (Object)this.jobStatusAsString()).add("OutputDataConfig", (Object)this.outputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "EndedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "EnrollmentConfig": {
                return Optional.ofNullable(clazz.cast(this.enrollmentConfig()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobProgress": {
                return Optional.ofNullable(clazz.cast(this.jobProgress()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpeakerEnrollmentJob, T> g) {
        return obj -> g.apply((SpeakerEnrollmentJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String dataAccessRoleArn;
        private String domainId;
        private Instant endedAt;
        private EnrollmentConfig enrollmentConfig;
        private FailureDetails failureDetails;
        private InputDataConfig inputDataConfig;
        private String jobId;
        private String jobName;
        private JobProgress jobProgress;
        private String jobStatus;
        private OutputDataConfig outputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeakerEnrollmentJob model) {
            this.createdAt(model.createdAt);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.domainId(model.domainId);
            this.endedAt(model.endedAt);
            this.enrollmentConfig(model.enrollmentConfig);
            this.failureDetails(model.failureDetails);
            this.inputDataConfig(model.inputDataConfig);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.jobProgress(model.jobProgress);
            this.jobStatus(model.jobStatus);
            this.outputDataConfig(model.outputDataConfig);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final EnrollmentConfig.Builder getEnrollmentConfig() {
            return this.enrollmentConfig != null ? this.enrollmentConfig.toBuilder() : null;
        }

        public final void setEnrollmentConfig(EnrollmentConfig.BuilderImpl enrollmentConfig) {
            this.enrollmentConfig = enrollmentConfig != null ? enrollmentConfig.build() : null;
        }

        @Override
        public final Builder enrollmentConfig(EnrollmentConfig enrollmentConfig) {
            this.enrollmentConfig = enrollmentConfig;
            return this;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final JobProgress.Builder getJobProgress() {
            return this.jobProgress != null ? this.jobProgress.toBuilder() : null;
        }

        public final void setJobProgress(JobProgress.BuilderImpl jobProgress) {
            this.jobProgress = jobProgress != null ? jobProgress.build() : null;
        }

        @Override
        public final Builder jobProgress(JobProgress jobProgress) {
            this.jobProgress = jobProgress;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(SpeakerEnrollmentJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public SpeakerEnrollmentJob build() {
            return new SpeakerEnrollmentJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpeakerEnrollmentJob> {
        public Builder createdAt(Instant var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder domainId(String var1);

        public Builder endedAt(Instant var1);

        public Builder enrollmentConfig(EnrollmentConfig var1);

        default public Builder enrollmentConfig(Consumer<EnrollmentConfig.Builder> enrollmentConfig) {
            return this.enrollmentConfig((EnrollmentConfig)((EnrollmentConfig.Builder)EnrollmentConfig.builder().applyMutation(enrollmentConfig)).build());
        }

        public Builder failureDetails(FailureDetails var1);

        default public Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return this.failureDetails((FailureDetails)((FailureDetails.Builder)FailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder jobProgress(JobProgress var1);

        default public Builder jobProgress(Consumer<JobProgress.Builder> jobProgress) {
            return this.jobProgress((JobProgress)((JobProgress.Builder)JobProgress.builder().applyMutation(jobProgress)).build());
        }

        public Builder jobStatus(String var1);

        public Builder jobStatus(SpeakerEnrollmentJobStatus var1);

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }
    }
}

