/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.voiceid.VoiceIdClient;
import software.amazon.awssdk.services.voiceid.internal.UserAgentUtils;
import software.amazon.awssdk.services.voiceid.model.FraudsterSummary;
import software.amazon.awssdk.services.voiceid.model.ListFraudstersRequest;
import software.amazon.awssdk.services.voiceid.model.ListFraudstersResponse;

public class ListFraudstersIterable
implements SdkIterable<ListFraudstersResponse> {
    private final VoiceIdClient client;
    private final ListFraudstersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFraudstersIterable(VoiceIdClient client, ListFraudstersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFraudstersResponseFetcher();
    }

    public Iterator<ListFraudstersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FraudsterSummary> fraudsterSummaries() {
        Function<ListFraudstersResponse, Iterator> getIterator = response -> {
            if (response != null && response.fraudsterSummaries() != null) {
                return response.fraudsterSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFraudstersResponseFetcher
    implements SyncPageFetcher<ListFraudstersResponse> {
        private ListFraudstersResponseFetcher() {
        }

        public boolean hasNextPage(ListFraudstersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFraudstersResponse nextPage(ListFraudstersResponse previousPage) {
            if (previousPage == null) {
                return ListFraudstersIterable.this.client.listFraudsters(ListFraudstersIterable.this.firstRequest);
            }
            return ListFraudstersIterable.this.client.listFraudsters((ListFraudstersRequest)((Object)ListFraudstersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

