/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FraudDetectionDecision {
    HIGH_RISK("HIGH_RISK"),
    LOW_RISK("LOW_RISK"),
    NOT_ENOUGH_SPEECH("NOT_ENOUGH_SPEECH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FraudDetectionDecision> VALUE_MAP;
    private final String value;

    private FraudDetectionDecision(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FraudDetectionDecision fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FraudDetectionDecision> knownValues() {
        EnumSet<FraudDetectionDecision> knownValues = EnumSet.allOf(FraudDetectionDecision.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FraudDetectionDecision.class, FraudDetectionDecision::toString);
    }
}

